import * as tf from '@tensorflow/tfjs';

// Tworzymy model sekwencyjny (nazywany także podstawową siecią neurnową).
const model = tf.sequential();

// Dodajemy do sieci warstwy.
model.add(tf.layers.dense({units: 4, activation: 'relu', inputDim: 2}));
model.add(tf.layers.dense({units: 4, activation: 'relu', inputDim: 2}));
model.add(tf.layers.dense({units: 1, activation: 'sigmoid'}));

// Przygotowujemy model do uczenia: określamy funkcję straty i optymalizator.
const learningRate = 1;
const optimizer = tf.train.sgd(learningRate);
model.compile({loss: 'binaryCrossentropy', optimizer, metrics: ['accuracy']});

// Wartości x danych XOR.
const xs = tf.tensor([
    [0, 0],
    [0, 1],
    [1, 0],
    [1, 1]
],
// Kształt tensoru to: 4 wiersze x 2 kolumny
[4, 2]);

// Wartości y danych XOR.
const ys = tf.tensor([ 0, 1, 1, 0 ], [4, 1]);


// Uczymy model używając do tego przygotowanych danych.
model.fit(xs, ys, {epochs: 1000}).then(() => {
    // Używamy modelu do przeanalizowania punktu danych,
    // którego model wcześniej nie widział.
    console.log("Uczenie zakończone. Przetwarzanie modelu...");

    const r = model.evaluate(xs, ys);
    console.log("Strata: ");
    r[0].print();
    console.log("Dokładność: ");
    r[1].print();

    console.log("Testowanie - 0, 0");
    model.predict(tf.tensor2d([0, 0], [1, 2])).print();
    console.log("Testowanie - 0, 1");
    model.predict(tf.tensor2d([0, 1], [1, 2])).print();
    console.log("Testowanie - 1, 0");
    model.predict(tf.tensor2d([1, 0], [1, 2])).print();
    console.log("Testowanie - 1, 1");
    model.predict(tf.tensor2d([1, 1], [1, 2])).print();
});