import KMeans from './kmeans.js';
import example_data from './data.js';
import KMeansAutoSolver from './kmeans-autosolver';

console.log("\nUczenie maszynowe w języku JavaScript. Rozdział 4. Grupowanie metodą k-średnich.");
console.log("===============================================\n");

console.log("Testowanie generowania centroidów:");
console.log("===============================================\n");

const ex_randomCentroids_solver = new KMeans(2, example_data.example_randomCentroids);

console.log("Losowo zainicjowane centroidy: ");
console.log(ex_randomCentroids_solver.centroids);
console.log("\n-----------------------------------------------\n\n");

// --- przykład 1: dane dwuwymiarowe, 3 klastry -------------------------- //

console.log("Rozwiązywanie przykładu: dane dwuwymiarowe, 3 klastry:");
console.log("===============================================\n");

console.log("Wyniki przkładu: dane dwuwymiarowe, 3 klastry:");
console.log("-------------------------------------");
const ex_1_solver = new KMeans(3, example_data.example_2d3k);
const ex_1_centroids = ex_1_solver.solve();
console.log(ex_1_centroids);
console.log("");

console.log("Dziennik iteracji dla przykładu: dane dwuwymiarowe, 3 klastry:");
console.log("------------------------------------------");
ex_1_solver.iterationLogs.forEach(log => console.log(log));
console.log("");

console.log("Testowanie przykładu: dane dwuwymiarowe, 3 klastry - 5 iteracji");
console.log("----------------------------------------");
for (let i = 0; i < 5; i++) {
  ex_1_solver.reset();
  const solution = ex_1_solver.solve();
  console.log(solution);
}
console.log("");


// --- przykład 2: dane trójwymiarowe, 3 klastry -------------------------- //

console.log("Rozwiązywanie przykładu: dane trójwymiarowe, 3 klastry:");
console.log("===============================================\n");
console.log("Wyniki przykładu: dane trójwymiarowe, 3 klastry:");
console.log("-------------------------------------");
const ex_2_solver = new KMeans(3, example_data.example_3d3k);
const ex_2_centroids = ex_2_solver.solve();
console.log(ex_2_centroids);
console.log("");

// --- przykład 3.: dane dwuwymiarowe o nieznanej liczbie klastrów --- //

console.log("Rozwiązywanie przykładu: dane dwuwymiarowe o nieznanej liczbie klastrów:");
console.log("===============================================\n");
console.log("Wyniki przykładu: dane dwuwymiarowe o nieznanej liczbie klastrów:");
console.log("-------------------------------------");
const ex_3_solver = new KMeansAutoSolver(1, 30, 5, example_data.example_2dnk);   
const ex_3_solution = ex_3_solver.solve();
console.log(ex_3_solution);

//*/