# Aplikacje oparte na uczeniu maszynowym

## Kody źródłowe dołączone do książki.

## Instalacja

Repozytorium zostało przetestowane w wersjach Pythona 3.6 i 3.7.
Powinno funkcjonować poprawnie we wszystkich wariantach wersji 3.

Przejdź do katalogu repozytorium i utwórz środowisko wirtualna
Pythona za pomocą następującego polecenia:

virtualenv ml_editor

Aktywuj środowisko:

source ml_editor/bin/activate

Zainstaluj niezbędne moduły:

pip install -r requirements.txt

Potrzebnych jest kilka modeli z biblioteki spacy. Aby pobrać mały 
i duży model dla języka angielskiego (niezbędne do uruchomienia 
aplikacji i notatników) wpisz następujące polecenia:

python -m spacy download en_core_web_sm

python -m spacy download en_core_web_lg

Ponadto notatniki i biblioteka wymagają pakietu nltk. Pakiet 
wykorzystuje zestaw zasobów, które trzeba osobno pobrać. W tym 
celu otwórz sesję Pythona, zaimportuj pakiet nltk i pobierz 
niezbędne zasoby.

Poniżej znajduje się przykład, jak to zrobić dla pakietu punkt po zainstalowaniu nltk:

python
import nltk
nltk.download('punkt')



## Przykładowe notatniki

Folder notebooks zawiera notatniki ilustrujące pojęcia opisane w książce. 
W większości przykładów wykorzystany jest tylko jeden podfolder 
w archiwum (zawierający dane z serwisu writers.stackexchange.com).

Dla wygody, przetworzone dane umieściłem w plikach .csv.

Jeżeli chcesz samodzielnie wygenerować dane lub wygenerować je dla innego folderu, wykonaj następujące operacje:
- Pobierz folder z archiwum https://archive.org/details/stackexchange.
- Uruchom program parse_xml_to_csv, aby przekonwertować dane do obiektu DataFrame
- Uruchom program generate_model_text_features, aby wygenerować obiekty DataFrame ze wstępnie wyliczonymi cechami

Notatniki należą do następujących kategorii:

Badanie i przekształcanie danych
Początkowe trenowanie modelu i analiza jego wydajności
Ulepszanie modelu
Porównywanie modeli
Formułowanie zaleceń za pomocą modeli




## Wstępnie przetrenowane modele

Za pomocą notatników umieszczonych w folderze notebooks możesz trenować 
i zapisywać modele. Dla Twojej wygody, w folderze models umieściłem trzy 
przetrenowane modele i dwa wektoryzatory. Modele są ładowane do notatników 
porównujących wyniki, jak również do aplikacji Flask.




## Uruchomienie prototypowej aplikacji Flask

Aby uruchomić aplikację, wystarczy przejść do głównego folderu repozytorium 
i wpisać polecenie:

FLASK_APP=app.py flask run

Powinna się uruchomić przeglądarka z lokalną stroną o adresie http://127.0.0.1:5000/.




## Diagnostyka

Jeżeli będziesz miał pytania lub napotkasz problemy, wyślij mi wiadomość 
na adres mlpoweredapplications@gmail.com.

Struktura projektu oparta na doskonałym artykule na stronie 
https://drivendata.github.io/cookiecutter-data-science.
