# Deep Learning From Scratch

To repozytorium zawiera cały kod z książki [Uczenie głębokie od zera], opublikowanej przez wydawnictwo O'Reilly we wrześniu 2019; wydanie polskie zostało opublikowane przez wydawnictwo Helion w 2020 roku.

Utworzyłem je przede wszystkim dla siebie, aby porządkować kod pisany na potrzeby tej książki. Mam jednak nadzieję, że użytkownicy
sklonują to repozytorium i będa systematycznie samodzielnie wykonywać kod, aby lepiej zrozumieć omawiane zagadnienia.


## Struktura

Do każdego rozdziału dołączone są dwa pliki: `Code` i `Math`. W plikach `Code` znajduje się kod w Pythonie do poszczególnych
rozdziałów. Można go uruchamiać, aby wygenerować wyniki z danego rozdziału. Pliki `Math` tworzyłem w celu przechowywania
równań w języku LaTeX używanych w tej książce. Wykorzystałem tu mechanizm wyświetlania kodu w języku LaTeX dostępny
w Jupyterze.

### `lincoln`

W plikach z rozdziałów 4., 5. i 7. importuję klasy z biblioteki `lincoln`, zamiast umieszczać te klasy bezpośrednio w tych
plikach. Biblioteki `lincoln` nie da się na razie instalować za pomocą narzędzia `pip`. Sposób na importowanie jej w plikach 
(aby móc wykonać zapisany w nich kod) polega na dodaniu wiersza o następującym formacie do pliku `.bashrc`:

```bash
export PYTHONPATH=$PYTHONPATH:/Users/seth/development/DLFS_code/lincoln
```

Dzięki temu Python będzie szukał w tej ścieżce modułu o nazwie `lincoln`, gdy uruchomisz polecenie `import` (oczywiście
musisz zastąpić podaną tu ścieżkę odpowiednią ścieżką ze swojej maszyny po sklonowaniu repozytorium). Następnie wywołaj
polecenie `source` dla pliku `.bashrc` przed uruchomieniem instrukcji `jupyter notebook` i wszystko powinno działać poprawnie.

### Rozdział 5. Przykładowa operacja konwolucyjna z wykorzystaniem biblioteki NumPy

Choć w tekście książki nie poświęcam temu tematowi dużo miejsca, zaimplementowałem wielokonałową operację konwolucji
z wykorzystaniem biblioteki NumPy (w dodatku do książki opisuję jak to zrobić i prezentuję kod). W [tym pliku](05_convolutions/Numpy_Convolution_Demos.ipynb) pokazuję, jak używać tej operacji do uczenia jednowarstwowej konwolucyjnej
sieci neuronowej napisanej od podstaw z użyciem biblioteki NumPy, aby uzyskać ponad 90% trafności dla zbioru danych MNIST.
