# Instalacja

## Pobierz to repozytorium
Aby zainstalować to repozytorium i uruchomić notatniki Jupyter na swoim komputerze, będziesz potrzebował narzędzia git, które być może już posiadasz. Możesz to sprawdzić otwierając terminal i wpisując `git`. Jeśli nie masz narzędzia git, możesz pobrać je na stronie [git-scm.com](https://git-scm.com/).

Następnie sklonuj to repozytorium otwierając terminal i wpisując poniższe polecenia (pomiń pierwszy symbol $ w każdym wierszu, gdyż nie jest to część kodu Pythona, lecz symbol wskazujący zachętę terminala):

    $ cd $HOME  # lub dowolny inny katalog roboczy
    $ git clone https://github.com/ageron/handson-ml3.git
    $ cd handson-ml3

Jeżeli nie chcesz instalować narzędzia git, możesz zamiast tego pobrać archiwum [main.zip](https://github.com/ageron/handson-ml3/archive/main.zip), rozpakować je, zmienić nazwę przechowującego je katalogu na `handson-ml3` i przenieść go do katalogu roboczego.

## Zainstaluj Anacondę
Będziesz potrzebować środowiska Python 3 i kilka bibliotek Pythona. Najprościej jest [pobrać i zainstalować Anacondę](https://www.anaconda.com/distribution/), czyli znakomitą, międzyplatformową dystrybucję Pythona służącą do obliczeń naukowych. Zawiera ona wiele wbudowanych bibliotek naukowych, takich jak NumPy, Pandas, Matplotlib, Scikit-Learn itd., więc pliki instalacyjne są dość pokaźnych rozmiarów. Jeśli zależy Ci na mniejszej dystrybucji Anacondy, możesz [zainstalować Minicondę](https://docs.conda.io/en/latest/miniconda.html), która zawiera niezbędne minimum zasobów potrzebnych do uruchomienia narzędzia `conda`. Powinieneś zainstalować najbardziej aktualną wersję Anacondy (lub Minicondy).

Podczas instalacji w systemach MacOSX lub Linux zostaniesz zapytany, czy Anaconda ma zostać zainicjalizowana za pomocą `conda init`: powinieneś zaakceptować, gdyż w ten sposób zostanie zaktualizowany Twój skrypt powłoki tak, żeby polecenie `conda` było zawsze dostępne po uruchomieniu terminala. Aby zmiany zostały przyjęte do końca, musisz zamknąć terminal i otworzyć nowy.

Podczas instalacji w systemie Windows zostaniesz zapytany, czy instalator ma zaktualizować zmienną środowiskową `PATH`. Nie jest to zalecane, gdyż wpływa na inne oprogramowanie. Zamiast tego po zakończeniu instalacji powinieneś otworzyć menu Start i uruchamiać powłokę Anacondy (Anaconda Shell) za każdym razem, gdy będziesz chciał skorzystać z Anacondy.

Po zainstalowaniu Anacondy/Minicondy wpisz poniższe polecenie, aby zaktualizować narzędzie `conda` do najnowszej wersji:

    $ conda update -n base -c defaults conda

> **Uwaga**: jeżeli z jakiegoś powodu nie przepadasz za Anacondą, możesz zainstalować środowisko Python 3 i użyć menedżera pip, aby własnoręcznie zainstalować wymagane biblioteki (nie jest to zalecane rozwiązanie, jeżeli nie wiesz, jak to zrobić). Zalecam korzystanie z wersji Python 3.7, gdyż niektóre biblioteki nie obsługują jeszcze wersji 3.8 ani 3.9.


## Zainstaluj sterownik i biblioteki karty graficznej
Jeżeli dysponujesz kartą graficzną kompatybilną z modułem TensorFlow (kartą firmy NVidia wyposażoną w funkcję Compute Capability ≥ 3.5) i chcesz, aby moduł TensorFlow korzystał z jej możliwości, powinieneś pobrać najnowszą wersję jej sterownika ze strony [nvidia.com](https://www.nvidia.com/Download/index.aspx?lang=en-us) i zainstalować go. Będą potrzebne także biblioteki CUDA i cuDNN, ale dobra wiadomość jest taka, że zostaną one automatycznie zainstalowane wraz z pakietem tensorflow-gpu z poziomu Anacondy. Jeśli jednak nie korzystasz z Anacondy, będziesz musiał własnoręcznie zainstalować te biblioteki. W przypadku jakichkolwiek problemów zajrzyj do odpowiedniej [instrukcji instalacji](https://tensorflow.org/install/gpu).

## Utwórz środowisko `homl3`
Przejdź teraz do katalogu `handson-ml3` i wpisz następujące polecenie. Zostanie utworzone nowe środowisko `conda`, zawierające wszystkie wszystkie biblioteki niezbędne do uruchamiania kodu zawartego w poszczególnych notatnikach (środowisko to domyślnie będzie nazwane `homl3`, ale może zmienić tę nazwę za pomocą opcji `-n`):

    $ conda env create -f environment.yml

Uaktywnij teraz to środowisko:

    $ conda activate tf2

## Uruchom środowisko Jupyter
Już niemal gotowe! Musisz jeszcze tylko zarejestrować środowisko `homl3` w aplikacji Jupyter. Stanowiące część naszego projektu notatniki domyślnie będą uruchamiane w środowisku nazwanym `python3`, dlatego najlepiej zarejestrować nasze środowisko pod nazwą `python3` (jeżeli zdecydujesz się na inną nazwę, będziesz musiał ją wybierać w menu "Kernel > Change kernel..." za każdym razem, gdy będziesz otwierał notatnik):

    $ python3 -m ipykernel install --user --name=python3

To wszystko! Możesz teraz uruchomić aplikację Jupyter następująco:

    $ jupyter notebook

Aplikacja powinna pojawić się w Twojej przeglądarce i wyświetli się widok hierarchiczny treści bieżącego katalogu. Jeżeli przegladarka nie uruchomi się automatycznie, wejdź na adres [localhost:8888](http://localhost:8888/tree). Kliknij plik `index.ipynb`, aby wyświetlić spis treści.

Gratulacje! Jesteś gotowy do rozpoczęcia nauki uczenia maszynowego!

Jeśli chcesz wyłączyć aplikację Jupyter, wystarczy wcisnąć kombinację klawiszy Ctrl+C w oknie terminala, w którym została uruchomiona. Za każdym razem, gdy będziesz chciał pracować z tym projektem, musisz otworzyć Terminal i wpisać:

    $ cd $HOME # lub inny, wyznaczony wcześniej katalog projektu
    $ cd handson-ml3 
    $ conda activate homl3
    $ jupyter notebook

## Aktualizuj ten projekt i jego biblioteki

Regularnie aktualizuję notatniki, aby rozwiązywać różne problemy i dodawać wsparcie dla nowych bibliotek. Pamiętaj więc o regularnym aktualizowaniu tego projektu.

W tym celu otwórz terminal i wpisz:

    $ cd $HOME # lub inny, wyznaczony wcześniej katalog projektu
    $ cd handson-ml3 # przejdź do katalogu tego projektu
    $ git pull

Jeżeli wyskoczy jakiś błąd, to prawdopodobnie dlatego, że zmodyfikowałeś notatnik. W takim przypadku przed wpisaniem polecenia `git pull` będziesz musiał najpierw zatwierdzić swoje zmiany. Zalecam zrobienie tego we własnej gałęzi, gdyż w przeciwnym wypadku mogą wystąpić konflikty:

    $ git checkout -b moja_gałąź # możesz wpisać inną nazwę gałęzi
    $ git add -u
    $ git commit -m "opisz tu wprowadzone zmiany"
    $ git checkout main
    $ git pull

Zaktualizujmy teraz biblioteki. Po pierwsze zaktualizujmy samą w sobie Anacondę:

    $ conda update -c defaults -n base conda

Następnie zaktualizujemy środowisko `homl3` tego projektu:

    $ conda activate base
    $ conda env remove -n homl3

I odtworzymy środowisko:

    $ conda env create -f environment.yml

Na koniec uruchomimy ponownie środowisko oraz aplikację Jupyter:

    $ conda activate homl3
    $ jupyter notebook