interface Product {
    name: string;
    price: number;
}

class SportsProduct implements Product {
    constructor(public name: string, public category: string,
            public price: number) {
        // Polecenia nie są wymagane.
    }
}

class ProductGroup {
    constructor(...initialProducts: [string, Product][]) {
        initialProducts.forEach(p => this[p[0]] = p[1]);
    }

    [propertyName: string]: Product;
}

let group
    = new ProductGroup(["shoes", new SportsProduct("Buty do biegania", "bieganie", 90.50)]);
group.hat = new SportsProduct("Czapka", "narciarstwo", 20);

let total = group.hat.price + (group.boots?.price ?? 0);
console.log(`Wartość całkowita: ${total}`);
