<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml"/>

<!-- przeksztalc html na wml -->
<xsl:template match="html">
<wml>
<xsl:apply-templates match="@*|*|text()"/>
</wml>
</xsl:template>

<!-- skopiuj wszystkie elementy html wraz z atrybutami i zawartoscia. 
Za wyjatkiem szablonow znajdujacych sie za tym -->
<xsl:template match="*"> <!-- html|head|meta -->
<xsl:copy>
<xsl:apply-templates match="@*|*|text()"/>
</xsl:copy>
</xsl:template>

<!-- zastap naglowki tekstem z atrybutem big -->
<xsl:template match="h1|h2|h3|h4|h5|h6|h7|h8|h9">
<big>
<xsl:value-of select="."/>
</big>
</xsl:template>

<!-- skopiuj ponizsze elementy bez kopiowania ich atrybutow -->
<xsl:template match="table|tr|td">
<xsl:copy>
<xsl:apply-templates/>
</xsl:copy>
</xsl:template>

<!-- zamien th to td -->
<xsl:template match="th">
<td class="th">
<xsl:apply-templates/>
</td>
</xsl:template>

<!-- zamien body na card -->
<xsl:template match="body">
<card title="{/html/head/title}">
<xsl:apply-templates/>
</card>
</xsl:template>

<!-- zastap ponizsze elementy na ich zawartosc z dodanym znakiem konca linii -->
<xsl:template match="li|dt|hr">
<xsl:apply-templates/>
<br/>
</xsl:template>

<!-- zastap ponizsze elementy na akapit -->
<xsl:template match="div|ul|ol|dl|blockquote|form">
<p>
<xsl:apply-templates/>
</p>
</xsl:template>

<!-- zignoruj ponizsze elementy -->
<xsl:template match="title">
</xsl:template>

</xsl:stylesheet>
