<?php

	header('Content-Type: application/json');

	// Dołącza definicje klas przed wywołaniem session_start()
	require_once ('../../server/classes/class.dbutil.php');
	require_once ('../../server/classes/class.users.php');
	require_once ('../../server/classes/class.buildings.php');
	require_once ('../../server/classes/class.operations.php');
	require_once ('../../server/classes/class.user.php');
	require_once ('../../server/config.php');

	session_start();

	if (count($_GET) != 0 && isset($_SESSION['userSession'])) {

		// Sprawdza, czy wszystkie parametry mają prawidłowe wartości
		if (!is_numeric($_GET['buildingId']) ||
			!is_numeric($_GET['x']) ||
			!is_numeric($_GET['y']) ||
			intval($_GET['x']) < 0 ||
			intval($_GET['y']) < 0 ||
			intval($_GET['x']) > GRID_X ||
			intval($_GET['y']) > GRID_Y) {
			die('ERROR');
		}

	  $DB = new DBUtil(DB_HOST,		// Nazwa hosta serwera bazy danych
				   	 DB_USER,		// Użytkownik bazy danych
				   	 DB_PASSWORD,	// Hasło użytkownika bazy danych
				   	 DB_NAME);		// Nazwa bazy danych

		if ($DB) {
			$UserUtil = new UserUtil($DB);
			$BuildingUtil = new BuildingUtil($DB);
			$OperUtil = new OperationsUtil($DB);

			// Sprawdza, czy to prawidłowy budynek
			$building = $BuildingUtil->getBuildingById((int) $_GET['buildingId']);

			if ($building) {
				
				$user = $UserUtil->getUserById($_SESSION['userSession']->getId());

				// Czy użytkownik ma wystarczająco dużo pieniędzy, by to zamówić?
				if ($user && $user->getBalance() >= $building->getCost()) {
					
					// Pobiera instancje budynków tego użytkownika
					$inst = $OperUtil->findBuildingInstanceByXY($user->getId(), $_GET['x'], $_GET['y']);

					// Zamawianie
					if (!$inst) {

						// Tworzy instancję budynku
						$bi = new BuildingInstance(null, $user->getId(), $building->getId(), (int)$_GET['x'], (int)$_GET['y']);
						$bi = $OperUtil->create($bi);	

						// Pobiera pieniądze
						$user->setBalance($user->getBalance() - $building->getCost());

						// Aktualizuje użytkownika
						$UserUtil->update($user);

						// Wyświetla instancję budynku
						die('OK:' . $bi->getId()); 
					}
				}
			}

			die('ERROR');

		}
	} else {
		die('ERROR');
	}
?>
