<?php
/*
 * Szkolenie: Bezpieczeństwo aplikacji internetowych
 * Plik składowy przykładowego projektu
 * Autor: Marcin Lis, http://marcinlis.com
 * Uwaga: Do wszystkich projektów w celach demonstracyjnych zostały wprowdzone błędy.
 * Tych przykładów nigdy nie należy używać w praktyce.
 */
 
class Site
{
  private $filespath = '/var/www/files/';
  function setMessage($msg)
  {
    $_SESSION['message'] = $msg;
  }
  function getMessage()
  {
    if(isset($_SESSION['message'])){
      $message = $_SESSION['message'];
      unset($_SESSION['message']);
      return $message;
    }
    return false;
  }
  function getFilesList()
  {
    $files = array();
    if($dir = scandir($this->filespath)){
      foreach($dir as $file){
        if(is_file($this->filespath.$file)){
          $files[] = $file;
        }
      }
    }
    return $files;
  }
  function getFile()
  {
    if(!isset($_REQUEST['filename'])){
      $this->setMessage('Nieprawidłowe wywołanie.');
      return ACTION_FAILED;
    }
    
    $filename = $_REQUEST['filename'];
    
    if(!file_exists($this->filespath.$filename)){
      $this->setMessage('Brak wskazanego pliku.');
      return ACTION_FAILED;
    }
    
    header('Content-Type: application/octet-stream');
    header('Content-Disposition: attachment; filename='.$filename);
    header('Content-Length: ' . filesize($this->filespath.$filename));
    readfile($this->filespath.$filename);
    
  }
  function showMain()
  {
    $message = $this->getMessage();
    $files = $this->getFilesList();
    include 'tmpl/main.tpl.php';
  }
}

?>