<?php
/*
 * Szkolenie: Bezpieczeństwo aplikacji internetowych
 * Plik składowy przykładowego projektu
 * Autor: Marcin Lis, http://marcinlis.com
 * Uwaga: Do wszystkich projektów w celach demonstracyjnych zostały wprowdzone błędy.
 * Tych przykładów nigdy nie należy używać w praktyce.
 */
 
class AdminSite
{
  private $dbo = null;
  
  function initDB($host, $user, $pass, $db)
  {
    try{
      $this->dbo = new PDO("mysql:dbname=$db;host=$host;charset=utf8", $user, $pass);
      //Wyłącznie emulacji zapytań parametryzowanych
      //$this->dbo->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
    }
    catch(PDOException $e){
      $msg = "Brak połączenia z bazą danych: ";
      $msg .= $e->getMessage();
      throw new Exception($msg);
    }
  }
  
  function setMessage($msg)
  {
    $_SESSION['message'] = $msg;
  }
  function getMessage()
  {
    if(isset($_SESSION['message'])){
      $message = $_SESSION['message'];
      unset($_SESSION['message']);
      return $message;
    }
    return false;
  }
  
  function login()
  {
    if(isset($_REQUEST['user']) && isset($_REQUEST['pass'])){
      //symulacja logowania
      $_SESSION['zalogowany'] = true;
      $this->setMessage('Zalogowanie prawidłowe');
      return ACTION_OK;
    }
    else{
      $this->setMessage("Brak danych.");
      return ACTION_FAILED;
    }
  }
  
  function logout()
  {
    if(isset($_SESSION['zalogowany'])){
      unset($_SESSION['zalogowany']);
      $this->setMessage('Wylogowanie prawidłowe.');
    }
    else{
      $this->setMessage('Najpierw się zaloguj.');
    }
  }
  
  function getVisits()
  {
    $query  = "SELECT * FROM Visits WHERE 1 = 1 ORDER BY czas DESC LIMIT 20 ";
    
    if(!$result = $this->dbo->query($query)){
      $this->setMessage('Lista wizyt nie jest dostępna.');
      return array();
    }
    
    if(!$rows = $result->fetchAll()){
      $this->setMessage('Brak wizyt.');
      return array();
    }  
    return $rows;
  }
  
  function showvisits()
  {
    if(!isset($_SESSION['zalogowany'])){
      $this->setMessage("Musisz się zalogować.");
      header('Location: index.php');
      return;
    }
    $zalogowany = isset($_SESSION['zalogowany']);
    $visits = $this->getVisits();    
    $message = $this->getMessage();
    
    include 'tmpl/visits.tpl.php';
  }
  
  function showMain()
  {
    $message = $this->getMessage();
    $zalogowany = isset($_SESSION['zalogowany']);
    include 'tmpl/main.tpl.php';
  }
}

?>