<?php
/*
 * Szkolenie: Bezpieczeństwo aplikacji internetowych
 * Plik składowy przykładowego projektu
 * Autor: Marcin Lis, http://marcinlis.com
 * Uwaga: Do wszystkich projektów w celach demonstracyjnych zostały wprowdzone błędy.
 * Tych przykładów nigdy nie należy używać w praktyce.
 */
define("LOGIN_OK", 1);
define("LOGIN_FAILED", 2);
define("SERVER_ERROR", 3);
 
class Site
{
  private $dbo = null;
  function initDB($host, $user, $pass, $db)
  {
    $this->dbo = new mysqli($host, $user, $pass, $db);
    if($this->dbo->connect_errno){
      $msg = "Brak połączenia z bazą danych: ";
      $msg .= $this->dbo->connect_error;
      throw new Exception($msg);
    }
  }
  function mycrypt($data, $key, $decrypt = false)
  {
    $td = mcrypt_module_open('tripledes', '', 'ecb', '');
    $iv = mcrypt_create_iv(mcrypt_enc_get_iv_size($td), MCRYPT_RAND);
    mcrypt_generic_init($td, $key, $iv);
    if($decrypt){
      $output = mdecrypt_generic($td,  base64_decode($data));
    }
    else{
      $output = base64_encode(mcrypt_generic($td, $data));
    }
    mcrypt_generic_deinit($td);
    mcrypt_module_close($td);
    return $output;
  }
  function login()
  {
    unset($_SESSION['zalogowany']);
    
    if(!$this->dbo){
      $this->setMessage('Błąd serwera. Zalogowanie nie jest możliwe.');
      return SERVER_ERROR;
    }
    
    //Sprawdzenie czy zostały przekazane parametry.
    if(!isset($_POST["user"]) || !isset($_POST["pass"]) || 
        $_POST["user"] == '' || $_POST["pass"] == ''){
      $this->setMessage('Nieprawidłowe dane.');
      return LOGIN_FAILED;
    }
    
    $user = $_POST["user"];
    $pass = $_POST["pass"];
    $pass = $this->mycrypt($pass, 'supertajnyklucz', false);
    
    //Wykonanie zapytania sprawdzającego poprawność danych.
    $query = "SELECT Haslo, Nazwa, Id ";
    $query .= "FROM Users WHERE Nazwa='$user' AND Haslo='$pass'";

    if(!$result = $this->dbo->query($query)){
      $this->setMessage('Błąd serwera. Zalogowanie nie jest możliwe.');
      return SERVER_ERROR;
    }
    
    //Sprawdzenie wyników zapytania.
    if($result->num_rows){
      $row = $result->fetch_row();
      $this->setMessage("Jesteś zalogwany jako {$row[1]}.");
      $_SESSION['zalogowany'] = $row[1];
      return LOGIN_OK;
    }
    else{
      $this->setMessage('Nieprawidłowa nazwa lub hasło.');
      return LOGIN_FAILED;
    }
  }
  function logout()
  {
    unset($_SESSION['zalogowany']);
    header('Location:index.php');
  }
  function setMessage($msg)
  {
    $_SESSION['message'] = $msg;
  }
  function deleteMessage()
  {
    if(isset($_SESSION['message'])){
      unset($_SESSION['message']);
    }
  }
  function showMain()
  {
    if(isset($_SESSION['zalogowany'])){
      include 'tmpl/main.tpl';
    }
    else{
      include 'tmpl/form.tpl';
    }
  }
}

?>