﻿using Microsoft.Live;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Windows.Storage;
using Windows.Storage.Streams;
using Windows.UI.Popups;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Media.Imaging;

namespace MojeSpotkania
{
    class SkyDrive
    {
        private LiveConnectClient klient;
        private MessageDialog komunikat;

        public SkyDrive(LiveConnectClient klient) 
        {
            this.klient = klient;
        }

        /// <summary>
        /// Metoda do przesyłania zdjęcia na SkyDrive. Zdjęcie zostanie umieszczone w głównym katalogu SkyDrive. W przypadku nastąpienia na plik o takiej samej nazwie, plik zostanie nadpisany.
        /// </summary>
        /// <param name="bitmapImage">Obraz przesyłanego zdjęcia.</param>
        /// <param name="nazwaPliku">Nazwa z jaką zostanie zapisane zdjęcie.</param>
        /// <returns> id zdjęcia na SD</returns>
        public async Task<string> WyslijZdjecie(StorageFile obraz, string nazwaPliku)
        {
            string trescKomuikatu = "";
            string nazwaFolderu = "me/skydrive/";
                try
                {
                    LiveOperationResult wynik = await klient.BackgroundUploadAsync(nazwaFolderu, nazwaPliku, obraz, OverwriteOption.Overwrite);
                    return wynik.Result["id"].ToString();

                }
                catch (LiveConnectException exc)
                {
                    trescKomuikatu = "Wystąpił błąd podczas przesyłania zdjecia: " + exc.Message;                    
                }
                if (trescKomuikatu != "") 
                {
                    komunikat = new MessageDialog(trescKomuikatu);
                    await komunikat.ShowAsync();                    
                }
                return "-1";
            }

        /// <summary>
        /// Metoda usuwająca dowolny obiekt na SkyDrive (np: folder, wydarzenie w kalendarzu lub zdjęcie biletu).
        /// </summary>
        /// <param name="idObiektu">Id obiektu na Skydrive</param>
        public async void UsunObiektNaSD (string idObiektu){
            string trescKomunikatu = "";
            try
            {
                LiveOperationResult wynik = await klient.DeleteAsync(idObiektu);
            }
            catch (LiveConnectException exc)
            {
                trescKomunikatu = "Wystąpił błąd podczas połączenia z usługą Live: " + exc.Message;                
            }
            catch (ArgumentException exc)
            {
                komunikat = new MessageDialog("Wystąpił błąd podczas usuwania pliku: " + exc.Message);
            }
            if (trescKomunikatu != "")
            {
                komunikat = new MessageDialog(trescKomunikatu);
                await komunikat.ShowAsync();
            }

        }
        /// <summary>
        /// Metoda dodająca wydarzenie do kalendarza użytkownika
        /// </summary>
        /// <param name="nazwa">Nazwa wydarzenia</param>
        /// <param name="opis">Opis wydarzenia</param>
        /// <param name="start">Data rozpoczecia wydarzenia</param>
        /// <param name="koniec">Data zakończenia wydarzenia</param>
        /// <param name="miejsce">Miejsce wydarzenia</param>
        /// <param name="wydarzenieCalodobowe">Czy wydarzenie jest całodobowe</param>
        /// <returns>Id wydarzenia na SkyDrive</returns>
        public async Task<string> DodajWydarzenieDoKalendarza(string nazwa, string opis, DateTime start, DateTime koniec, string miejsce) {
            string trescKomunikatu = "";
            try
            {
                var calEvent = new Dictionary<string, object>();
                calEvent.Add("name", nazwa);
                calEvent.Add("description", opis);
                calEvent.Add("start_time", start.ToString("yyyy-MM-dd HH:mm:ss+0000"));
                calEvent.Add("end_time", koniec.ToString("yyyy-MM-dd HH:mm:ss+0000"));
                calEvent.Add("location", miejsce);
                calEvent.Add("is_all_day_event", false);
                calEvent.Add("availability", "busy");
                calEvent.Add("visibility", "private");
                LiveOperationResult wynik = await klient.PostAsync("me/events", calEvent);
                trescKomunikatu = "Wydarzenie zostało dodane do Twojego kalendarza.";                
                return wynik.Result["id"].ToString();
                
            }
            catch (LiveConnectException exc)
            {
                trescKomunikatu = "Wystąpił błąd podczas dodawania spotkania do kalendarza: " + exc.Message;                                
            }
            if (trescKomunikatu != "")
            {
                komunikat = new MessageDialog(trescKomunikatu);
                await komunikat.ShowAsync();
            }
            return "";
        }

    }
}
