﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Windows.UI.Popups;
using Windows.UI.Xaml.Media.Imaging;
using Windows.Web.Syndication;

namespace MojeSpotkania
{
    /// <summary>
    /// Klasa przechowuje wszystkie kanały RSS jeśli posiadamy ich większą ilość.
    /// </summary>
    public class KanalyRSS
    {
        private ObservableCollection<KanalRSS> _Kanaly = new ObservableCollection<KanalRSS>(); //obiekt typu ObservableCollection pozwala na powiązanie tego obiektu ze stroną StronaRSS.xaml
        public ObservableCollection<KanalRSS> Kanaly
        {
            get
            {
                return this._Kanaly;
            }
        }

        /// <summary>
        /// Asynchroniczna metoda pobierająca kanały rss z podanych źródeł
        /// </summary>
        /// <returns>Task, co zgodnie z teorią asynchroniczności jest obietnicą, że w miejscu tego obiektu, po zakonczeniu operacji pobierania danych, pojawi się jakiś obiekt (jakiś, bo typ Task, tego nie definiuje). </returns>
        public async Task PobierzKanalyRSS()
        {
            Roaming roaming = new Roaming();
            string adresKanalu = (string)(await roaming.ZaładujDowolnyObiektZRoamingu("kanal1RSS"));// Pobieramy zmienną przechowywaną w roamingu
            Task<KanalRSS> kanal1 = PobierzKanalRSS(adresKanalu);                               // Kanal pobieramy z adresu przechowywanego w zmiennej adresKanalu, 
                                                                                                // ale równie dobrze możemy użyć polecenie posiadające bezpośredni adres kanału np.:
                                                                                                // PobierzKanalRSS("http://www.codeguru.geekclub.pl/rss/24add730-74aa-4cda-b92f-4a872b0a0921"); 

            this.Kanaly.Add(await kanal1);
        }

        /// <summary>
        /// Metoda pobierająca wskazany kanał RSS
        /// </summary>
        /// <param name="stringUriKanalu">url kanału RSS</param>
        /// <returns>Task, co zgodnie z teorią asynchroniczności jest obietnicą, że w miejscu tego obiektu, po zakonczeniu operacji pobierania danych, pojawi się obiekt typu KanalRSS.</returns>
        private async Task<KanalRSS> PobierzKanalRSS(string stringUriKanalu)
        {
            // definiowanie zmiennych. Wymagane jest odwołanie using Windows.Web.Syndication
            SyndicationClient klient = new SyndicationClient();
            Uri uriKanalu = new Uri(stringUriKanalu);

            try
            {
                SyndicationFeed kanal = await klient.RetrieveFeedAsync(uriKanalu);

                KanalRSS daneKanalu = new KanalRSS();

                daneKanalu.Tytul = kanal.Title.Text;
                if (kanal.Subtitle != null && kanal.Subtitle.Text != null)
                {
                    daneKanalu.Podtytul = kanal.Subtitle.Text;
                }

                if (daneKanalu.Obraz != null)
                {
                    daneKanalu.Obraz.Source = new BitmapImage(kanal.ImageUri);
                }
                
                daneKanalu.Data = kanal.Items[0].PublishedDate.DateTime.ToString();

                foreach (SyndicationItem obiektKanalu in kanal.Items)
                {
                    ElementKanaluRSS daneObiektuKanalu = new ElementKanaluRSS();
                    daneObiektuKanalu.Tytul = obiektKanalu.Title.Text;                          
                    daneObiektuKanalu.Data = obiektKanalu.PublishedDate.DateTime.ToString("MM-dd-yyyy H:mm:ss");
                    
                    if (kanal.SourceFormat == SyndicationFormat.Atom10)
                    {
                        daneObiektuKanalu.Tresc = obiektKanalu.Content.Text;
                        daneObiektuKanalu.Link = new Uri(stringUriKanalu + obiektKanalu.Id);
                    }
                    else if (kanal.SourceFormat == SyndicationFormat.Rss20)
                    {
                        daneObiektuKanalu.Tresc = obiektKanalu.Summary.Text;
                        daneObiektuKanalu.Link = obiektKanalu.Links[0].Uri;
                    }
                    daneKanalu.ObiektyKanaluRSS.Add(daneObiektuKanalu);
                }
                return daneKanalu;
            }
            catch (Exception)
            {
                return null;
            }
        }
    }
}
