﻿package {
	
	import flash.display.MovieClip;
	import flash.events.AccelerometerEvent;
	import flash.sensors.Accelerometer;
	
	public class Main extends MovieClip {
		
		private const THRESHOLD:Number = 0.8;
		
		private var acc   :Accelerometer;
		private var prevX :Number;
		private var prevY :Number;
		private var prevZ :Number;
		private var startX:Number;
		private var startY:Number;
		
		public function Main() {
			prevX = prevY = prevZ = 0;
			
			shake.gotoAndStop(1);
			startX = shake.x;
			startY = shake.y;
			
			if(Accelerometer.isSupported)
			{
				acc = new Accelerometer();
				acc.setRequestedUpdateInterval(50);
				acc.addEventListener(AccelerometerEvent.UPDATE, accUpdated);
			}
		}
		
		private function accUpdated(e:AccelerometerEvent):void {
			var changeX:Number = prevX - e.accelerationX;
			var changeY:Number = prevY - e.accelerationY;
			var changeZ:Number = prevZ - e.accelerationZ;
					
			prevX = e.accelerationX;
			prevY = e.accelerationY;
			prevZ = e.accelerationZ;
					
			shake.x = startX + (changeX * 100);
			shake.y = startY + (changeY * 100);
			shake.z = (changeZ * 100);
					
			if(Math.abs(changeX) > THRESHOLD || Math.abs(changeY) > THRESHOLD || Math.abs(changeZ) > THRESHOLD)
			{
				shake.gotoAndStop(2);
			}
			else
			{
				shake.gotoAndStop(1);
			}
		}
	}
}
