﻿package {
	
	import flash.display.MovieClip;
	import flash.utils.Timer;
	import flash.events.TimerEvent;
	import flash.events.Event;
	
	public class Main extends MovieClip {
		
		private const DURATION:uint = 5;
		private var frames:uint = 0;
		
		public function Main() {
			addEventListener(Event.ENTER_FRAME, enterFrame);
			
			msgField.visible = false;
			
			var t:Timer = new Timer(DURATION * 1000, 1);
			t.addEventListener(TimerEvent.TIMER_COMPLETE, timerComplete);
			t.start();
			
			for(var i:uint = 0; i < 10; i++)
			{
				var monkey:Monkey = new Monkey();				
				monkey.x = Math.random() * (stage.stageWidth - monkey.width);
				monkey.y = Math.random() * (stage.stageHeight - monkey.height);
				addChild(monkey);
			}
		}
		
		private function timerComplete(e:TimerEvent):void {
			removeEventListener(Event.ENTER_FRAME, enterFrame);
			var fps:uint = frames / DURATION;
			msgField.visible = true;
			msgField.text = fps + " fps";
			addChild(msgField);
		}
		
		private function enterFrame(e:Event):void {
			frames++;
		}
	}
}
