﻿package {
	
	import flash.display.MovieClip;
	import flash.events.AccelerometerEvent;
	import flash.sensors.Accelerometer;
	
	public class Main extends MovieClip {
		
		private var acc:Accelerometer;
		
		public function Main() {
			if(Accelerometer.isSupported)
			{
				acc = new Accelerometer();
				acc.setRequestedUpdateInterval(50);
				acc.addEventListener(AccelerometerEvent.UPDATE, accUpdated);
			}
		}
		
		private function accUpdated(e:AccelerometerEvent):void {
			var radians:Number = Math.atan2(e.accelerationY, e.accelerationX);
			var degrees:Number = (radians * (180 / Math.PI)) - 90;
			arrow.rotation = -degrees;
			
			accXField.text = e.accelerationX.toString();
			accYField.text = e.accelerationY.toString();
			accZField.text = e.accelerationZ.toString();
			timeField.text = e.timestamp.toString();
			rotField.text  = degrees.toString();
		}
	}
}
