import csv

def write_csv(filename, header, data):
    """Zapisywanie podanych danych w pliku CSV.
    :param str filename: Nazwa pliku, w którym należy zapisać dane.			
    :param list header: Nagłówek kolumny w pliku csv
    :param list data: Zagnieżdżona lista mapująca wartości na kolumny
    """
    try:
        with open(filename, 'w') as csv_file:
            csv_writer = csv.writer(csv_file)
            csv_writer.writerow(header)
            csv_writer.writerows(data)
    except (IOError, OSError) as csv_file_error:
        print("Nie można zapisać treści w pliku csv. Wyjątek: {}".format(csv_file_error))

if __name__ == '__main__':
    header = ['name', 'age', 'gender']
    data = [['Richard', 32, 'M'], ['Mumzil', 21, 'F'], ['Melinda', 25, 'F']]
    filename = 'sample_output.csv'
    write_csv(filename, header, data)
