from llama_index.core.agent import AgentRunner
from llama_index.agent.openai import OpenAIAgentWorker
from llama_index.tools.database import DatabaseToolSpec

db_tools = DatabaseToolSpec(uri="sqlite:///pliki//baza danych//employees.db")
tools = db_tools.to_tool_list()

step_engine = OpenAIAgentWorker.from_tools(
    tools,
    verbose=True
)

agent = AgentRunner(step_engine)
input =  (
    "Znajdź najlepiej opłacanego pracownika HR i napisz "
    "do niego e-mail z informacją o bonusie."
)

task = agent.create_task(input)
step_output = agent.run_step(task.task_id)

while not step_output.is_last:
    step_output = agent.run_step(task.task_id)

response = agent.finalize_response(task.task_id)
print(response)
