from llama_index.core.postprocessor import KeywordNodePostprocessor
from llama_index.core.schema import TextNode, NodeWithScore

nodes = [
    TextNode(
        text="Wpis nr: 1, <TAJNE> - Atak na Rzym"
    ),
    TextNode(
        text="Entry no: 2, <ZASTRZEŻONE> - Idź do punktu Brawo"
    ),
    TextNode(
        text="Entry no: 3, <PUBLICZNE> - Róże są czerwone"
    ),
]

node_with_score_list = [
    NodeWithScore(node=node) for node in nodes
]
pp = KeywordNodePostprocessor(
    exclude_keywords=["TAJNE", "ZASTRZEŻONE"]
)
remaining_nodes = pp.postprocess_nodes(
    node_with_score_list
)
print('Istotne węzły:')
for node_with_score in remaining_nodes:
    node = node_with_score.node
    print(f"Tekst: {node.text}")
