import chromadb
from llama_index.vector_stores.chroma import ChromaVectorStore
from llama_index.core import VectorStoreIndex, SimpleDirectoryReader, StorageContext

db = chromadb.PersistentClient(path="chroma_database")
chroma_collection = db.get_or_create_collection(
    "my_chroma_store"
)

vector_store = ChromaVectorStore(
    chroma_collection=chroma_collection
)
storage_context = StorageContext.from_defaults(
    vector_store=vector_store
)

documents = SimpleDirectoryReader("pliki").load_data()
index = VectorStoreIndex.from_documents(
    documents=documents, 
    storage_context=storage_context
)

#Ta część wyświetla zawartość bazy danych ChromaDB 
results = chroma_collection.get()
print(results)

''' Następną część można wykorzystać do przywrócenia indeksu z ChromaDB w przyszłych sesjach
index = VectorStoreIndex.from_vector_store(
    vector_store=vector_store, 
    storage_context=storage_context
)
'''

