from llama_index.tools.database import DatabaseToolSpec
from llama_index.core.tools import FunctionTool
from llama_index.agent.openai import OpenAIAgent
from llama_index.llms.openai import OpenAI

def write_text_to_file(text, filename):
    """
    Zapisuje tekst w pliku, a następnie plik zapisuje pod określona nazwą pliku.
    Args:
        text (str): Tekst, który ma być zapisany w pliku.
        filename (str): Nazwa pliku z zapisanym tekstem.
    Returns: None
    """
    with open(filename, 'w') as file:
        file.write(text)
        
save_tool = FunctionTool.from_defaults(fn=write_text_to_file)
db_tools = DatabaseToolSpec(uri="sqlite:///pliki//baza danych//employees.db")
tools = [save_tool]+db_tools.to_tool_list()

llm = OpenAI(model="gpt-4")
agent = OpenAIAgent.from_tools(
    tools=tools, 
    llm=llm, 
    verbose=True,
    max_function_calls=20
)

response = agent.chat(
    "Dla każdego pracownika działu IT z wynagrodzeniem niższym "
    "niż średnia pensja w organizacji, napisz email,"
    "ogłaszając 10% podwyżkę, a następnie zapisz wszystkie e-maile w "
    "pliku o nazwie 'emails.txt'")
print(response)
