-- Listing 8.7

-- Tworzenie DMK.
CREATE MASTER KEY
ENCRYPTION BY PASSWORD = 'P@55w0rd';

-- Tworzenie certyfikatu.
CREATE CERTIFICATE TestCertificate
WITH SUBJECT = N'Certyfikat testowy AdventureWorks',
EXPIRY_DATE = '2026-10-31';

-- Tekst do zaszyfrowania.
DECLARE @plaintext nvarchar(58) =
N'To jest tekst do zaszyfrowania';
SELECT 'Plain text = ', @plaintext;

-- Szyfrowanie tekstu certyfikatem.
DECLARE @ciphertext varbinary(128) =
EncryptByCert(Cert_ID('TestCertificate'), @plaintext);
SELECT 'Zaszyfrowany tekst = ', @ciphertext;

-- Rozszyfrowanie tekstu certyfikatem.
DECLARE @decryptedtext nvarchar(58) =
DecryptByCert(Cert_ID('TestCertificate'), @ciphertext);
SELECT 'Rozszyfrowany tekst = ', @decryptedtext;

-- Usunicie testowego certyfikatu.
DROP CERTIFICATE TestCertificate;

-- Usunicie DMK.
DROP MASTER KEY;
