-- Listing 8.10

-- Tworzenie DMK.
CREATE MASTER KEY
ENCRYPTION BY PASSWORD = 'P@55wOrd';

-- Tworzenie klucza asymetrycznego.
CREATE ASYMMETRIC KEY TestAsymmetricKey WITH ALGORITHM = RSA_512;

--Zapisanie numeru karty kredytowej do zaszyfrowania.
DECLARE @CreditCard nvarchar(26) = N'9000 1234 5678 9012';
SELECT @CreditCard;

--Zaszyfrowanie numeru karty kredytowej. 
DECLARE @EncryptedCreditCard varbinary(64) =
EncryptByAsymKey(AsymKey_ID(N'TestAsymmetricKey'), @CreditCard);
SELECT @EncryptedCreditCard;

--Odszyfrowanie numeru karty kredytowej.
DECLARE @DecryptedCreditCard nvarchar(26) =
DecryptByAsymKey(AsymKey_ID(N'TestAsymmetricKey'), @EncryptedCreditCard);
SELECT @DecryptedCreditCard;

-- Usunicie klucza asymetrycznego.
DROP ASYMMETRIC KEY TestAsymmetricKey;

-- Usunicie DMK. 
DROP MASTER KEY;
