-- Listing 7.11

CREATE TRIGGER Sales.vIndividualCustomerUpdate
ON Sales.vIndividualCustomer
INSTEAD OF UPDATE
NOT FOR REPLICATION
AS
BEGIN
  -- Upewnij si, czy zosta zmodyfikowany przynajmniej jeden wiersz.
  IF @@ROWCOUNT = 0 RETURN
  -- Usu komunikaty "rows affected". 
  SET NOCOUNT ON;
  -- Zainicjalizuj znacznik mwicy o udanej aktualizacji.
  DECLARE @UpdateSuccessful bit = 0;

  -- Sprawd modyfikowalne kolumny z pierwszej tabeli. 
  IF UPDATE(FirstName) OR UPDATE(MiddleName) OR UPDATE(LastName)
  BEGIN
    -- Zaktualizuj kolumny tabeli bazowej. 
    UPDATE Person.Person
    SET FirstName = i.FirstName,
      MiddleName = i.MiddleName,
      LastName = i.LastName
    FROM inserted i
    WHERE i.BusinessEntityID = Person.Person.BusinessEntityID;

    -- Ustaw znacznik udanej modyfikacji. 
    SET @UpdateSuccessful = 1;
  END;
  -- Jeli zostay okrelone kolumny modyfikowalne w drugiej tabeli, zaktualizuj odpowiednie kolumny w tabeli bazowej. 
  IF UPDATE(EmailAddress)
  BEGIN
    -- Zaktualizuj kolumny tabeli bazowej. 
    UPDATE Person.EmailAddress
    SET EmailAddress = i.EmailAddress
    FROM inserted i
    WHERE i.BusinessEntityID = Person.EmailAddress.BusinessEntityID;

    -- Ustaw znacznik udanej modyfikacji. 
    SET @UpdateSuccessful = 1;
  END;
  -- Jeli aktualizacja si nie powioda, wyrzu bd i wycofaj transakcj. 
  IF @UpdateSuccessful = 0
      RAISERROR('Musisz wskaza modyfikowalne kolumny.', 10, 127);
END;
GO

