program cw26_1;
{ Program ilustruje podstawowe dziaania na stosie: odkadanie elementu, }
{ zdejmowanie elementu i wypisywanie zawartoci stosu. }
uses
  Crt;
type
  TWskaznik = ^TElement;
  TElement  = record
                Slowo : String;        { zawarto elementu }
                Nast  : TWskaznik;     { wskanik na nastpny element }
              end;
var
  Stos : TWskaznik;                    { wskanik na wierzchoek stosu }
  Slowo : String;
  Znak : Char;

procedure Push(Slowo: String);
{ Procedura odkada sowo na stosie, czyli umieszcza  }
{ je na pocztku listy (o ile nie jest puste).        }
var
  E : TWskaznik;
begin
  if (Slowo <> '') then
  begin
    New(E);                    { utwrz nowy element }
    E^.Slowo := Slowo;         { zapisz w nim warto }
    E^.Nast := Stos;           { wskanik ma wskazywa nastpny element, }
    Stos := E;                 { a nowy element staje si pocztkiem stosu }
  end;
end; {------------------------------------------ Push -}

function Pop: String;
{ Funkcja zdejmuje ze stosu pierwsze sowo (jeli stos nie jest pusty) }
{ i je zwraca. Jeeli stos jest pusty - zwraca acuch pusty.          }
var
  E : TWskaznik;
begin
  if (Stos = Nil) then         { stos jest pusty  zwr acuch pusty }
    Pop := ''
  else
  begin
    E := Stos;                 { zapamitaj wierzchoek stosu }
    Pop := E^.Slowo;           { zwr pooony na nim acuch }
    Stos := E^.Nast;           { przesu wierzchoek do nastpnego elem. }
    Dispose(E);                { i usu element z gry stosu }
  end;
end; {------------------------------------------ Push -}

procedure WypiszStos;
{ Procedura wypisuje wszystkie elementy stosu. }
var
  E : TWskaznik;
begin
  E := Stos;
  while E <> nil do
  begin
    writeln (E^.Slowo);
    E := E^.Nast;
  end;
end; {------------------------------------ WypiszStos -}

begin
  Stos := nil;         { na pocztku stos jest pusty }
  repeat
    ClrScr;
    writeln ('P - poloz na stosie, Z - zdejmij ze stosu, ',
             'W - wypisz stos, K - koniec');
    Znak := UpCase(ReadKey);
    case Znak of
      'P' : begin      { odczytaj acuch i po go na stosie }
              repeat
                write('Podaj niepuste slowo: '); readln(Slowo);
              until (Slowo <> '');
              Push(Slowo);
              write('Na stosie umieszczono slowo ', Slowo);
            end;
      'Z' : begin      { zdejmij element ze stosu i wywietl go }
              Slowo := Pop;
              if Slowo = '' then
                writeln('Stos jest pusty!')
              else
                writeln('Ze stosu zdjeto slowo: ', Slowo);
            end;
      'W' : begin
              writeln ('Zawartosc stosu:'); writeln ('================');
              WypiszStos;
            end;
    else
      if Znak <> 'K' then
        writeln ('Zly klawisz.');
    end;
    writeln; write ('Nacisnij Enter, aby wrocic do menu'); readln;
  until (Znak = 'K');
end.
