program cw23_1;
{ Program porzdkuje tablic liczb typu Byte metod szybkiego sortowania. }
uses
  Crt;
const
  IleLiczb = 200;    { dla wartosci typu Byte - max. 65000 }
type
  TTablica = array[1..IleLiczb] of Byte;
var
  Tablica : TTablica;
  i : Word;

procedure QuickSort(var T : TTablica; Poczatek, Koniec : Word);
{ Procedura sortuje tablic liczb T metod szybkiego sortowania. }
{ Poczatek i Koniec okrelaj granice sortowanego podprzedziau. }
var
  Element, i : Word;
  Pomoc : Byte;
begin
  if (Poczatek < Koniec) then
  begin
    Element := Poczatek;
    for i := Poczatek+1 to Koniec do
      if (T[i] < T[Poczatek]) then     { zamie elementy miejscami }
      begin
        Element := Element + 1;
        Pomoc := T[Element]; T[Element] := T[i]; T[i] := Pomoc;
      end;
    Pomoc := T[Poczatek]; T[Poczatek] := T[Element]; T[Element] := Pomoc;
    { wywoaj rekurencyjnie dla obu podcigw pozostaych po rozdzieleniu }
    QuickSort(T, Poczatek, Element-1);
    QuickSort(T, Element+1, Koniec);
  end;
end; {------------------------------------- QuickSort -}

procedure WypiszTablice(var T : TTablica; Ile : Word);
{ Procedura wypisuje zawarto tablicy T. Sposb wypisywania dostosowano }
{ do zmiennych typu Byte (4 pola na warto).                            }
var
  i : Word;
begin
  for i := 1 to Ile do
    write(T[i]:4);
  writeln;
end; {-------------- WypiszTablice -}

begin
  ClrScr;
  { wypenij tablic liczbami i wypisz jej zawarto }
  Randomize;
  for i := 1 to IleLiczb do
    Tablica[i] := Random(256);
  WypiszTablice(Tablica, IleLiczb);
  readln;
  { sortuj tablic i ponownie wypisz jej zawarto }
  QuickSort(Tablica, 1, IleLiczb);
  WypiszTablice(Tablica, IleLiczb);
  readln;
end.
