program cw26_3;
{ Program pokazuje podstawowy sposb obsugi kolejki:           }
{ umieszczanie elementu w kolejce i pobieranie go do obsugi.   }
uses
  Crt;
type
  TWskaznik = ^TElement;
  TElement  = record
                Liczba : Byte;         { zawarto elementu }
                Nast   : TWskaznik;    { wskanik na nastpny }
              end;
var
  Kolejka : TWskaznik;                 { wskanik na pocztek kolejki }
  Liczba : Byte;
  Znak : Char;
  P : Pointer;

procedure Ustaw(Liczba: Byte);
{ Procedura ustawia element na kocu kolejki. }
var
  E, Pop, Nast : TWskaznik;
begin
  New(E);                              { utwrz nowy element }
  E^.Liczba := Liczba;                 { ustaw jego zawarto }
  if (Kolejka = nil) then              { wstaw na pocztku (jedyny 
  element) }
  begin
    E^.Nast := Kolejka; Kolejka := E;
  end
  else
  begin                                { przejd na koniec kolejki }
    Pop := Kolejka; Nast := Kolejka^.Nast;
    while (Nast <> nil) do
    begin
      Pop := Nast;
      Nast := Nast^.Nast;
    end;
    E^.Nast := Nast;                   { i dopisz tam element }
    Pop^.Nast := E;
  end;
end; {------------------------------ Ustaw -}

function Obsluz : Byte;
{ Funkcja zwraca warto pierwszego elementu z kolejki }
{ do obsuenia, jednoczenie go z niej usuwajc.      }
var
  E : TWskaznik;
begin
  if (Kolejka = nil) then      { kolejka pusta  nie ma czego obsugiwa }
    Obsluz := 0
  else
  begin
    E := Kolejka;              { pobierz pierwszy element }
    Obsluz := E^.Liczba;       { zwr jego warto }
    Kolejka := E^.Nast;        { i usu go z kolejki }
  end;
end; {------------------------------------------ Obsluz -}

procedure WypiszKolejke;
{ Procedura wypisuje wszystkie elementy kolejki.   }
var
  E : TWskaznik;
begin
  E := Kolejka;
  while E <> nil do            { przejd po wszystkich elementach }
  begin                        { a do koca i wypisz je }
    write(E^.Liczba, ' ');
    E := E^.Nast;
  end;
end; {----------------------------- WypiszKolejke -}

begin
  Mark(P);                     { zaznacz pocztek wolnego obszaru pamici }
  Kolejka := nil;              { kolejka jest jeszcze pusta }
  repeat
    ClrScr;
    write ('Kolejka: ');
    WypiszKolejke;
    writeln; writeln ('U - ustaw w kolejce, O - obsluz, K - koniec');
    Znak := UpCase(ReadKey);
    case Znak of
      'U' : begin              { dodaj element na kocu kolejki }
              repeat
                write('Podaj liczbe z zakresu (1..255): ');
                readln(Liczba);
              until Liczba > 0;
              Ustaw(Liczba);
            end;
      'O' : begin              { pobierz element z pocztku do obsuenia }
              Liczba := Obsluz;
              if Liczba = 0 then
                writeln('Nie ma czego obslugiwac, kolejka pusta.')
              else
                writeln('Element do obsluzenia: ', Liczba);
            end;
    end;
    if ((Znak='U') or (Znak='O')) then
    begin
      write('Nowa kolejka: '); WypiszKolejke;
      writeln; writeln('Wcisnij Enter'); readln;
    end;
  until (Znak = 'K');
  Release(P);          { zwolnij uyt pami }
end.
