program cw26_2;
{ Program ilustruje podstawow operacj na sowniku: }
{ dodawanie elementu w kolejnoci alfabetycznej.     }
uses
  Crt;
type
  TWskaznik = ^TElement;
  TElement  = record
                Slowo : String;        { zawarto elementu }
                Nast  : TWskaznik;     { wskanik na nastpny }
              end;
var
  Slownik : TWskaznik;                 { wskanik na pocztek sownika }
  Slowo : String;
procedure Dodaj (Slowo: String);
{ Procedura dodaje sowo do sownika, zachowujc porzdek alfabetyczny. }
var
  E, Pop, Nast : TWskaznik;
begin
  New(E);                      { utwrz nowy element }
  E^.Slowo := Slowo;           { ustaw jego zawarto }
  if (Slownik = nil) or (Slownik^.Slowo > Slowo) then  { wstaw na pocztku }
  begin
    E^.Nast := Slownik; Slownik := E;
  end
  else
  begin
    Pop := Slownik; Nast := Slownik^.Nast;
    while (Nast <> nil) and (Nast^.Slowo<Slowo) do     { szukaj pierwszego }
    begin                                              { wikszego sowa }
      Pop := Nast;
      Nast := Nast^.Nast;
    end;
    E^.Nast := Nast;                                   { i wstaw przed nim }
    Pop^.Nast := E;
  end;
end; {------------------------------------- Dodaj -}

procedure WypiszSlownik;
{ Procedura wypisuje wszystkie elementy sownika.  }
var
  E : TWskaznik;
begin
  E := Slownik;
  while E <> nil do
  begin
    write (E^.Slowo, ' ');
    E := E^.Nast;
  end;
end; {----------------------------- WypiszSlownik -}

begin
  Slownik := nil;
  repeat
    ClrScr;
    write ('Slownik: ');
    WypiszSlownik;
    writeln;
    write ('Podaj slowo (lub Enter by zakonczyc): ');
    readln (Slowo);
    if (Slowo <> '') then Dodaj (Slowo);
  until (Slowo = '');
end.
