program cw22_1;
{ Program wczytuje do zmiennej typu rekordowego opis samochodu }
{ i drukuje jego "metryczk".                                  }
uses
  Crt;
type
  TKolor = (bialy, czerwony, zielony, niebieski, srebrny);
  TTyp = (osobowy, ciezarowy);
  TWyposazenie = array[1..10] of String[30];
  TSamochod = record   { opis pojedynczego samochodu }
                Marka : String[20];
                Model : String[20];
                Typ : TTyp;
                Kolor : TKolor;
                NumerRejestracyjny : String[7];
                NumerNadwozia : String[30];
                NumerSilnika : String[30];
                Przebieg : Longint;
                DodatkoweWyposazenie : TWyposazenie;
              end;
var
  Samochod : TSamochod;
  Znak : Char;
  i : Byte;
  Wyposazenie : String[30];

begin
  { odczytaj dane samochodu }
  ClrScr;
  write('Podaj marke: '); readln(Samochod.Marka);
  write('Podaj model: '); readln(Samochod.Model);
  repeat               { odczytaj typ ze sprawdzeniem poprawnoci }
    write('Podaj typ(''O'' - osobowy, ''C'' - ciezarowy): ');
    readln(Znak);
  until(UpCase(Znak) in ['O', 'C']);
  case UpCase(Znak) of
    'O' : Samochod.Typ := osobowy;
    'C' : Samochod.Typ := ciezarowy;
  end;
  repeat               { odczytaj kolor ze sprawdzeniem poprawnoci }
    writeln('Podaj kolor (''B'' - bialy, ''C'' - czerwony, ''Z'' - zielony');
    write  ('             ''N'' - niebieski, ''S'' - srebrny): ');
    readln(Znak);
  until (Upcase(Znak) in ['B', 'C', 'Z', 'N', 'S']);
  case Upcase(Znak) of
    'B' : Samochod.Kolor := bialy;
    'C' : Samochod.Kolor := czerwony;
    'Z' : Samochod.Kolor := zielony;
    'N' : Samochod.Kolor := niebieski;
    'S' : Samochod.Kolor := srebrny;
  end;
  write('Podaj numer rejestracyjny: ');
  readln(Samochod.NumerRejestracyjny);
  write('Podaj numer nadwozia: ');
  readln(Samochod.NumerNadwozia);
  write('Podaj numer silnika: ');
  readln(Samochod.NumerSilnika);
  write('Podaj przebieg: ');
  readln(Samochod.Przebieg);
  i := 1;
  repeat               { odczytaj wyposaenie dodatkowe do tablicy }
    write('Podaj kolejny element wyposazenia (Enter - koniec): ');
    readln(Wyposazenie);
    Samochod.DodatkoweWyposazenie[i] := Wyposazenie; Inc(i);
  until (i > 10) or (Wyposazenie='');
  { wypisz dane samochodu }
  ClrScr;
  with Samochod do
  begin
    writeln(Marka, ', ', Model, ', ', NumerRejestracyjny);
    writeln('Numer nadwozia: ', NumerNadwozia, ', Numer silnika: ', 
             NumerSilnika, ', Przebieg: ', Przebieg);
    case Typ of
      osobowy : write('Samochod osobowy');
      ciezarowy : write('Samochod ciezarowy');
    end;
    case Kolor of
      bialy     : writeln(' koloru bialego');
      czerwony  : writeln(' koloru czerwonego');
      zielony   : writeln(' koloru zielonego');
      niebieski : writeln(' koloru niebieskiego');
      srebrny   : writeln(' koloru srebrnego');
    end;
    for i := 1 to 10 do
      if (DodatkoweWyposazenie[i] <> '') then
        writeln(' - ', DodatkoweWyposazenie[i]);
  end;
  readln
end.
