import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;

/**
 * MulticastNode jest bardzo prostym programem testujcym rozsyanie grupowe.
 * Po uruchomieniu program przycza si do grupy rozsyania grupowego 228.0.0.4
 * z portem 45564 (jest to domylny adres i port komunikacji w grupie Cluster
 * serwera Tomcat 6). Program uywa pierwszego argumentu jako komunikatu wysyanego
 * do grupy rozsyania grupowego, a nastpnie reszt czasu spdza na oczekiwaniu
 * na komunikaty z innych wzw i wywietlaniu ich zawartoci przy wykorzystaniu
 * standardowego wyjcia.
 */
public class MulticastNode {
    InetAddress group = null;
    MulticastSocket s = null;

    /**
     * Przekazanie programowi argumentu w postaci acucha, ktry powinien zosta
     * wysany do grupy rozsyania grupowego.
     */
    public static void main(String[] args) {
    
    if (args.length > 0) {
            System.out.println("Wysyanie komunikatu: " + args[0]);

            // Uruchomienie programu MulticastNode
            MulticastNode node = new MulticastNode( );

            // Wysyanie komunikatu
            node.send(args[0]);

            // Oczekiwanie na komunikaty z grupy rozsyania grupowego  
            // i wywietlanie ich wszystkich
            node.receive( );

        } else {

            System.out.println("acuch wymagany do wysania.");
            System.exit(1);
        }
    }

    /**
     * Doczanie programu MulticastNode do grupy 228.0.0.4 z portem 45564.
     */
    public MulticastNode( ) {

        try {

            group = InetAddress.getByName("228.0.0.4");
            s = new MulticastSocket(45564);
            s.joinGroup(group);

        } catch (Exception e) {

            e.printStackTrace( );
        }
    }

     /**
     * Wysanie komunikatu do grupy rozsyania grupowego, ktry bdzie
     * widoczny dla wszystkich.
     *
     * Ustawienie parametru msg dla komunikatu wysyanego do grupy rozsyania grupowego.
     */
    public void send(String msg) {

        try {

            DatagramPacket hi = new DatagramPacket(
                msg.getBytes(), msg.length( ), group, 45564);
            s.send(hi);

        } catch (Exception e) {

            e.printStackTrace( );
        }
    }

    /**
     * Cigle wykonywana ptla. Program oczekuje na komunikaty wysane w
     * postaci obiektw DatagramPacket do grupy rozsyania grupowego przez 
     * inne wzy. Po pojawieniu si komunikat jest kierowany do standardowego
     * wyjcia, po czym program kontynuuje oczekiwanie na komunikaty.
     */
    public void receive( ) {

        byte[] buf;

        // Cigle wykonywana ptla
        while (true) {

            try {

                buf = new byte[1000];
                DatagramPacket recv = new DatagramPacket(buf, buf.length);
                s.receive(recv);
                System.out.println("Otrzymane: " + new String(buf));

            } catch (Exception e) {

                e.printStackTrace( );
            }
        }
    }
}