//: c14:Interrupt.java
// Alternatywne podejcie do stosowania 
// metody stop() kiedy wtek jest zablokowany.
// <applet code=Interrupt width=200 height=100>
// </applet>
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import com.bruceeckel.swing.*;

class Blocked extends Thread {
  public synchronized void run() {
    try {
      wait(); // Blokowanie
    } catch(InterruptedException e) {
      System.err.println("Przerwany");
    }
    System.out.println("Wyjcie z run()");
  }
}

public class Interrupt extends JApplet {
  private JButton 
    interrupt = new JButton("Przerwij");
  private Blocked blocked = new Blocked();
  public void init() {
    Container cp = getContentPane();
    cp.setLayout(new FlowLayout());
    cp.add(interrupt);
    interrupt.addActionListener(
      new ActionListener() {
        public 
        void actionPerformed(ActionEvent e) {
          System.out.println("Przycisk wcinity");
          if(blocked == null) return;
          Thread remove = blocked;
          blocked = null; // aby go zwolni
          remove.interrupt();
        }
      });
    blocked.start();
  }
  public static void main(String[] args) {
    Console.run(new Interrupt(), 200, 100);
  }
} ///:~
