//: c13:Trees.java
// Prosty przykad drzewa Swing. Drzewa s
// przewanie o wiele bardziej zoone.
// <applet code=Trees
//  width=250 height=250></applet>
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.tree.*;
import com.bruceeckel.swing.*;

// Przyjmuje tablic acuchw tekstowych i z pierwszego 
// elementu robi wierzchoek a z pozostaych licie:
class Branch {
  DefaultMutableTreeNode r;
  public Branch(String[] data) {
    r = new DefaultMutableTreeNode(data[0]);
    for(int i = 1; i < data.length; i++)
      r.add(new DefaultMutableTreeNode(data[i]));
  }
  public DefaultMutableTreeNode node() { 
    return r; 
  }
}  

public class Trees extends JApplet {
  String[][] data = {
    { "Kolor", "Czerwony", "Niebieski", "Zielony" },
    { "Smak", "Cierpki", "Sodki", "Mdy" },
    { "Dugo", "Krtki", "redni", "Dugi" },
    { "Gono", "Wysoka", "rednia", "Niska" },
    { "Tempereatura", "Wysoka", "rednia", "Niska" },
    { "Intensywno", "Wysoka", "rednia", "Niska" },
  };
  static int i = 0;
  DefaultMutableTreeNode root, child, chosen;
  JTree tree;
  DefaultTreeModel model;
  public void init() {
    Container cp = getContentPane();
    root = new DefaultMutableTreeNode("korze");
    tree = new JTree(root);
    // Dodaj suwak aby zaj si przesuwaniem:
    cp.add(new JScrollPane(tree), 
      BorderLayout.CENTER);
    // Przechwy model drzewa:
    model =(DefaultTreeModel)tree.getModel();
    JButton test = new JButton("Nacinij mnie");
    test.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e){
        if(i < data.length) {
          child = new Branch(data[i++]).node();
          // Co zostao ostatnio wybrane?
          chosen = (DefaultMutableTreeNode)
            tree.getLastSelectedPathComponent();
          if(chosen == null) chosen = root;
          // Model stworzy odpowiednie zdarzenie.
          // W odpowiedzi drzewo ma si uaktualni:
          model.insertNodeInto(child, chosen, 0);
          // Tutaj wstawiany jest nowy wierzchoek 
          // do wierzchoka aktualnie wybranego.
        }
      }
    });
    // Zmiana koloru przycisku:
    test.setBackground(Color.blue);
    test.setForeground(Color.white);
    JPanel p = new JPanel();
    p.add(test);
    cp.add(p, BorderLayout.SOUTH);
  }
  public static void main(String[] args) {
    Console.run(new Trees(), 250, 250);
  }
} ///:~
