//: c13:Menus.java
// Podmenu, pozycje wyboru, zamiana menu,
// mnemoniki (akceleratory) i polecenia akcji.
// <applet code=Menus width=300
// height=100> </applet>
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import com.bruceeckel.swing.*;

public class Menus extends JApplet {
  String[] flavors = { "Czekoladowe", "Truskawkowe",
    "Waniliowe", "Mitowe",
    "Mocca", "Rumowe",
    "Karmelowe", "Bakaliowe" };
  JTextField t = new JTextField("Nie ma smaku", 30);
  JMenuBar mb1 = new JMenuBar();
  JMenu 
    f = new JMenu("Plik"),
    m = new JMenu("Smaki"),
    s = new JMenu("Bezpieczestwo");
  // Alternatywne rozwizanie:
  JCheckBoxMenuItem[] safety = {
    new JCheckBoxMenuItem("Chro"),
    new JCheckBoxMenuItem("Ukryj")
  };
  JMenuItem[] file = {
    new JMenuItem("Otwrz"),
  };
  // Drugi pasek menu:
  JMenuBar mb2 = new JMenuBar();
  JMenu fooBar = new JMenu("innyPasek");
  JMenuItem[] other = {
    // Dodawanie do menu skrtw (mnemonikw)  
    // jest bardzo proste ale tylko elementom menu
    // mona przekaza je w konstruktorach:
    new JMenuItem("Ene", KeyEvent.VK_E),
    new JMenuItem("Due", KeyEvent.VK_D),
    // Bez skrtu:
    new JMenuItem("Rabe"),
  };
  JButton b = new JButton("Zamie menu");
  class BL implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      JMenuBar m = getJMenuBar();
      setJMenuBar(m == mb1 ? mb2 : mb1);
      validate(); // Odwie ramk
    }
  }
  class ML implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      JMenuItem target = (JMenuItem)e.getSource();
      String actionCommand = 
        target.getActionCommand();
      if(actionCommand.equals("Otwrz")) {
        String s = t.getText();
        boolean chosen = false;
        for(int i = 0; i < flavors.length; i++)
          if(s.equals(flavors[i])) chosen = true;
        if(!chosen)
          t.setText("Najpierw wybierz smak!");
        else
          t.setText("Otwieram "+ s +". Mniam, mniam!");
      }
    }
  }
  class FL implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      JMenuItem target = (JMenuItem)e.getSource();
      t.setText(target.getText());
    }
  }
  // Alternatywnie mona stworzy oddzieln klas
  // dla kadego z elementw menu. Wtedy nie trzeba
  // zgadywa, ktry to jest element:
  class FooL implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      t.setText("Wybrano ene");
    }
  }
  class BarL implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      t.setText("Wybrano due");
    }
  }
  class BazL implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      t.setText("Wybrano rabe");
    }
  }
  class CMIL implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      JCheckBoxMenuItem target = 
        (JCheckBoxMenuItem)e.getSource();
      String actionCommand = 
        target.getActionCommand();
      if(actionCommand.equals("Chro"))
        t.setText("Chro lody! " +
          "Chronienie jest ustawione na " + target.getState());
      else if(actionCommand.equals("Ukryj"))
        t.setText("Ukryj lody! " +
          "Czy jest zimno? " + target.getState());
    }
  }
  public void init() {
    ML ml = new ML();
    CMIL cmil = new CMIL();
    safety[0].setActionCommand("Chro");
    safety[0].setMnemonic(KeyEvent.VK_C);
    safety[0].addItemListener(cmil);
    safety[1].setActionCommand("Ukryj");
    safety[0].setMnemonic(KeyEvent.VK_U);
    safety[1].addItemListener(cmil);
    other[0].addActionListener(new FooL());
    other[1].addActionListener(new BarL());
    other[2].addActionListener(new BazL());
    FL fl = new FL();
    for(int i = 0; i < flavors.length; i++) {
      JMenuItem mi = new JMenuItem(flavors[i]);
      mi.addActionListener(fl);
      m.add(mi);
      // Dodaj separatory w rwnych odstpach:
      if((i+1) % 3 == 0) 
        m.addSeparator();
    }
    for(int i = 0; i < safety.length; i++)
      s.add(safety[i]);
    s.setMnemonic(KeyEvent.VK_A);
    f.add(s);
    f.setMnemonic(KeyEvent.VK_F);
    for(int i = 0; i < file.length; i++) {
      file[i].addActionListener(fl);
      f.add(file[i]);
    }
    mb1.add(f);
    mb1.add(m);
    setJMenuBar(mb1);
    t.setEditable(false);
    Container cp = getContentPane();
    cp.add(t, BorderLayout.CENTER);
    // Ustaw system do zamiany menu:
    b.addActionListener(new BL());
    b.setMnemonic(KeyEvent.VK_S);
    cp.add(b, BorderLayout.NORTH);
    for(int i = 0; i < other.length; i++)
      fooBar.add(other[i]);
    fooBar.setMnemonic(KeyEvent.VK_B);
    mb2.add(fooBar);
  }
  public static void main(String[] args) {
    Console.run(new Menus(), 300, 100);
  }
} ///:~
