//: c11:DirList2.java
// Wykorzystanie anonimowych klas wewntrznych.
import java.io.*;
import java.util.*;
import com.bruceeckel.util.*;
public class DirList2 {
  public static FilenameFilter 
  filter(final String afn) {
    // Utworzenie anonimowej klasy wewntrznej:
    return new FilenameFilter() {
      String fn = afn;
      public boolean accept(File dir, String n) {
        // Obcicie informacji o ciece:
        String f = new File(n).getName();
        return f.indexOf(fn) != -1;
      }
    }; // Koniec anonimowej klasy wewntrznej
  }
  public static void main(String[] args) {
    File path = new File(".");
    String[] list;
    if(args.length == 0)
      list = path.list();
    else 
      list = path.list(filter(args[0]));
    Arrays.sort(list,
      new AlphabeticComparator());
    for(int i = 0; i < list.length; i++)
      System.out.println(list[i]);
  }
} ///:~
