//: c11:Blips.java
// Proste wykorzystanie Externalizable i puapka.
import java.io.*;
import java.util.*;

class Blip1 implements Externalizable {
  public Blip1() {
    System.out.println("Konstruktor Blip1 ");
  }
  public void writeExternal(ObjectOutput out)
      throws IOException {
    System.out.println("Blip1.writeExternal");
  }
  public void readExternal(ObjectInput in)
     throws IOException, ClassNotFoundException {
    System.out.println("Blip1.readExternal");
  }
}

class Blip2 implements Externalizable {
  Blip2() {
    System.out.println("Konstruktor Blip2");
  }
  public void writeExternal(ObjectOutput out)
      throws IOException {
    System.out.println("Blip2.writeExternal");
  }
  public void readExternal(ObjectInput in)
     throws IOException, ClassNotFoundException {
    System.out.println("Blip2.readExternal");
  }
}

public class Blips {
  // Komunikaty o wyjtkach bd wypisane na konsol:
  public static void main(String[] args) 
  throws IOException, ClassNotFoundException {
    System.out.println("Konstruowanie obiektw:");
    Blip1 b1 = new Blip1();
    Blip2 b2 = new Blip2();
    ObjectOutputStream o =
      new ObjectOutputStream(
        new FileOutputStream("Blips.out"));
    System.out.println("Zapisywanie obiektw:");
    o.writeObject(b1);
    o.writeObject(b2);
    o.close();
    // Wydostajemy je z powrotem:
    ObjectInputStream in =
      new ObjectInputStream(
        new FileInputStream("Blips.out"));
    System.out.println("Odzyskiwanie b1:");
    b1 = (Blip1)in.readObject();
    // Oho! Wyrzucany jest wyjtek:
//! System.out.println("Odzyskiwanie b2:");
//! b2 = (Blip2)in.readObject();
  }
} ///:~
