//: c09:SetPerformance.java
import java.util.*;
import com.bruceeckel.util.*;

public class SetPerformance {
  private abstract static class Tester {
    String name;
    Tester(String name) { this.name = name; }
    abstract void test(Set s, int size, int reps);
  }
  private static Tester[] tests = {
    new Tester("dodawanie") { 
      void test(Set s, int size, int reps) {
        for(int i = 0; i < reps; i++) {
          s.clear();
          Collections2.fill(s, 
            Collections2.countries.reset(),size);
        }
      }
    },
    new Tester("zawieranie") { 
      void test(Set s, int size, int reps) {
        for(int i = 0; i < reps; i++)
          for(int j = 0; j < size; j++)
            s.contains(Integer.toString(j));
      }
    },
    new Tester("przegld") { 
      void test(Set s, int size, int reps) {
        for(int i = 0; i < reps * 10; i++) {
          Iterator it = s.iterator();
          while(it.hasNext())
            it.next();
        }
      }
    },
  };
  public static void 
  test(Set s, int size, int reps) {
    System.out.println("Testowany kontener klasy " + 
      s.getClass().getName() + " rozmiaru " + size);
    Collections2.fill(s, 
      Collections2.countries.reset(), size);
    for(int i = 0; i < tests.length; i++) {
      System.out.print(tests[i].name);
      long t1 = System.currentTimeMillis();
      tests[i].test(s, size, reps);
      long t2 = System.currentTimeMillis();
      System.out.println(": " + 
        ((double)(t2 - t1)/(double)size));
    }
  }
  public static void main(String[] args) {
    int reps = 50000;
    // Albo wybr liczby powtrze
    // z wiersza polece:
    if(args.length > 0)
      reps = Integer.parseInt(args[0]);
    // Mae:
    test(new TreeSet(), 10, reps);
    test(new HashSet(), 10, reps);
    // rednie:
    test(new TreeSet(), 100, reps);
    test(new HashSet(), 100, reps);
    // Due:
    test(new TreeSet(), 1000, reps);
    test(new HashSet(), 1000, reps);
  }
} ///:~
