//: c09:Collection1.java
// Rzeczy, ktre mona zrobi ze 
// wszystkim implementacjami Collection.
import java.util.*;
import com.bruceeckel.util.*;

public class Collection1 {
  public static void main(String[] args) {
    Collection c = new ArrayList();
    Collections2.fill(c, 
      Collections2.countries, 10);    
    c.add("dziesi");
    c.add("jedenacie");
    System.out.println(c);
    // Utworzenie tablicy z listy:
    Object[] array = c.toArray(); 
    // Utworzenie tablicy obiektw typu String z listy:
    String[] str = 
      (String[])c.toArray(new String[1]);
    // Wyszukanie najwikszego i najmniejszego elementu;
    // oznacza to rne rzeczy zalenie od sposobu
    // implementacji interfejsu Comparable:
    System.out.println("Collections.max(c) = " +
      Collections.max(c));
    System.out.println("Collections.min(c) = " +
      Collections.min(c));
    // Dodanie jednej kolekcji do innej
    Collection c2 = new ArrayList();
    Collections2.fill(c2, 
      Collections2.countries, 10);    
    c.addAll(c2);
    System.out.println(c);
    c.remove(CountryCapitals.pairs[0][0]);
    System.out.println(c);
    c.remove(CountryCapitals.pairs[1][0]);
    System.out.println(c);
    // Usunicie wszystkich elementw, ktre s
    // w kontenerze bdcym argumentem:
    c.removeAll(c2);
    System.out.println(c);
    c.addAll(c2);
    System.out.println(c);
    // Czy element jest w danej kolekcji?
    String val = CountryCapitals.pairs[3][0];
    System.out.println(
      "c.contains(" + val  + ") = " 
      + c.contains(val));
    // Czy podana kolekcja jest zawarta w drugiej kolekcji?
    System.out.println(
      "c.containsAll(c2) = "+ c.containsAll(c2));
    Collection c3 = ((List)c).subList(3, 5);
    // Zachowaj wszystkie elementy, ktre s w obu 
    // kolekcjach c2 i c3 (przecicie zbiorw):
    c2.retainAll(c3);
    System.out.println(c);
    // Wyrzucenie wszystkich elementw 
    // z c2, ktre s take w c3:
    c2.removeAll(c3);
    System.out.println("c.isEmpty() = " +
      c.isEmpty());
    c = new ArrayList();
    Collections2.fill(c, 
      Collections2.countries, 10);    
    System.out.println(c);
    c.clear(); // Usu wszystkie elementy
    System.out.println("po c.clear():");
    System.out.println(c);
  }
} ///:~
