//: c15:JabberClient.java
// Bardzo prosty klient wysyajcy wiersze tekstu
// do serwera i odczytujcy
// to, co przyle serwer.
import java.net.*;
import java.io.*;

public class JabberClient {
  public static void main(String[] args) 
      throws IOException {
    // Przekazanie null do getByName() produkuje
    // specjalny adres IP "lokalnej ptli" , dla 
    // testw na maszynie bez poczenia sieciowego:
    InetAddress addr = 
      InetAddress.getByName(null);
    // Alternatywnie moglibymy wykorzysta
    // jedn z poniszych postaci:
    // InetAddress addr = 
    //    InetAddress.getByName("127.0.0.1");
    // InetAddress addr = 
    //    InetAddress.getByName("localhost");
    System.out.println("adres = " + addr);
    Socket socket = 
      new Socket(addr, JabberServer.PORT);
    // Chronimy wszystko za pomoc bloku try-finally,
    // aby zapewni zamknicie gniazda:
    try {
      System.out.println("gniazdo = " + socket);
      BufferedReader in =
        new BufferedReader(
          new InputStreamReader(
            socket.getInputStream()));
      // Klasa PrintWriter automatycznie oprniajca
      // bufor:
      PrintWriter out =
        new PrintWriter(
          new BufferedWriter(
            new OutputStreamWriter(
              socket.getOutputStream())),true);
      for(int i = 0; i < 10; i ++) {
        out.println("cze " + i);
        String str = in.readLine();
        System.out.println(str);
      }
      out.println("KONIEC");
    } finally {
      System.out.println("zamykamy...");
      socket.close();
    }
  }
} ///:~
