//: c13:MessageBoxes.java
// Pokaz JOptionPane.
// <applet code=MessageBoxes 
// width=200 height=150> </applet>
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import com.bruceeckel.swing.*;

public class MessageBoxes extends JApplet {
  JButton[] b = { new JButton("Alarm"), 
    new JButton("Tak/Nie"), new JButton("Kolor"),
    new JButton("Wprowad"), new JButton("Trzy wartoci")
  };
  JTextField txt = new JTextField(15);
  ActionListener al = new ActionListener() {
    public void actionPerformed(ActionEvent e){
      String id = 
        ((JButton)e.getSource()).getText();
      if(id.equals("Alarm"))
        JOptionPane.showMessageDialog(null, 
          "azi po tobie jaki robak!", "Hej!", 
          JOptionPane.ERROR_MESSAGE);
      else if(id.equals("Tak/Nie"))
        JOptionPane.showConfirmDialog(null, 
          "lub nie", "wybierz tak", 
          JOptionPane.YES_NO_OPTION);
      else if(id.equals("Kolor")) {
        Object[] options = { "Czerwony", "Zielony" };
        int sel = JOptionPane.showOptionDialog(
          null, "Wybierz kolor!", "Ostrzeenie", 
          JOptionPane.DEFAULT_OPTION, 
          JOptionPane.WARNING_MESSAGE, null, 
          options, options[0]);
          if(sel != JOptionPane.CLOSED_OPTION)
            txt.setText(
              "Wybrany kolor: " + options[sel]);
      } else if(id.equals("Wprowad")) {
        String val = JOptionPane.showInputDialog(
            "Ile palcw widzisz?"); 
        txt.setText(val);
      } else if(id.equals("Trzy wartoci")) {
        Object[] selections = {
          "Pierwsza", "Druga", "Trzecia" };
        Object val = JOptionPane.showInputDialog(
          null, "Wybierz co", "Wprowad",
          JOptionPane.INFORMATION_MESSAGE, 
          null, selections, selections[0]);
        if(val != null)
          txt.setText(
            val.toString());
      }
    }
  };
  public void init() {
    Container cp = getContentPane();
    cp.setLayout(new FlowLayout());
    for(int i = 0; i < b.length; i++) {
      b[i].addActionListener(al);
      cp.add(b[i]);
    }
    cp.add(txt);
  }
  public static void main(String[] args) {
    Console.run(new MessageBoxes(), 200, 200);
  }
} ///:~
