//: c13:BeanDumper.java
// Inspekcja kontrolki Bean.
// <applet code=BeanDumper width=600 height=500>
// </applet>
import java.beans.*;
import java.lang.reflect.*;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import com.bruceeckel.swing.*;

public class BeanDumper extends JApplet {
  JTextField query = 
    new JTextField(20);
  JTextArea results = new JTextArea();
  public void prt(String s) {
    results.append(s + "\n");
  }
  public void dump(Class bean){
    results.setText("");
    BeanInfo bi = null;
    try {
      bi = Introspector.getBeanInfo(
        bean, java.lang.Object.class);
    } catch(IntrospectionException e) {
      prt("Nie mona wykona inspekcji " + 
        bean.getName());
      return;
    }
    PropertyDescriptor[] properties = 
      bi.getPropertyDescriptors();
    for(int i = 0; i < properties.length; i++) {
      Class p = properties[i].getPropertyType();
      prt("Typ waciwoci:\n  " + p.getName() +
        "Nazwa waciwoci:\n  " + 
        properties[i].getName());
      Method readMethod = 
        properties[i].getReadMethod();
      if(readMethod != null)
        prt("Metoda odczytu:\n  " + readMethod);
      Method writeMethod = 
        properties[i].getWriteMethod();
      if(writeMethod != null)
        prt("Metoda zapisu:\n  " + writeMethod);
      prt("====================");
    }
    prt("Metody publiczne:");
    MethodDescriptor[] methods =
      bi.getMethodDescriptors();
    for(int i = 0; i < methods.length; i++)
      prt(methods[i].getMethod().toString());
    prt("======================");
    prt("Obsuga zdarze:");
    EventSetDescriptor[] events = 
      bi.getEventSetDescriptors();
    for(int i = 0; i < events.length; i++) {
      prt("Typ odbiorcy:\n  " +
        events[i].getListenerType().getName());
      Method[] lm = 
        events[i].getListenerMethods();
      for(int j = 0; j < lm.length; j++)
        prt("Metoda odbiorcy:\n  " +
          lm[j].getName());
      MethodDescriptor[] lmd = 
        events[i].getListenerMethodDescriptors();
      for(int j = 0; j < lmd.length; j++)
        prt("Sygnatura metody:\n  " +
          lmd[j].getMethod());
      Method addListener = 
        events[i].getAddListenerMethod();
      prt("Metoda dodawania odbiorcy:\n  " +
          addListener);
      Method removeListener =
        events[i].getRemoveListenerMethod();
      prt("Metoda usuwania odbiorcy:\n  " +
        removeListener);
      prt("====================");
    }
  }
  class Dumper implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      String name = query.getText();
      Class c = null;
      try {
        c = Class.forName(name);
      } catch(ClassNotFoundException ex) {
        results.setText("Nie mona znale " + name);
        return;
      }
      dump(c);
    }
  }      
  public void init() {
    Container cp = getContentPane();
    JPanel p = new JPanel();
    p.setLayout(new FlowLayout());
    p.add(new JLabel("Pena nazwa Beana:"));
    p.add(query);
    cp.add(BorderLayout.NORTH, p);
    cp.add(new JScrollPane(results));
    Dumper dmpr = new Dumper();
    query.addActionListener(dmpr);
    query.setText("frogbean.Frog");
    // Wymuszenie operacji
    dmpr.actionPerformed(
      new ActionEvent(dmpr, 0, ""));
  }
  public static void main(String[] args) {
    Console.run(new BeanDumper(), 600, 500);
  }
} ///:~
