//: c11:MakeDirectories.java
// Demonstracja uycia klasy File w celu 
// tworzenia katalogw i manipulacji na plikach
import java.io.*;

public class MakeDirectories {
  private final static String usage =
    "Uycie: MakeDirectories sciezka1 ...\n" +
    "Tworzy wszystkie scieki\n" +
    "Uycie: MakeDirectories -d sciezka1 ...\n" +
    "Usuwa wszystkie scieki\n" +
    "Uycie: MakeDirectories -r sciezka1 sciezka2\n" +
    "Zmienia nazw scieka1 na scieka2\n";
  private static void usage() {
    System.err.println(usage);
    System.exit(1);
  }
  private static void fileData(File f) {
    System.out.println(
      "cieka absolutna: " + f.getAbsolutePath() +
      "\n Moliwo odczytu: " + f.canRead() +
      "\n Moliwo zapisu: " + f.canWrite() +
      "\n Nazwa: " + f.getName() +
      "\n Nadrzdna: " + f.getParent() +
      "\n cieka: " + f.getPath() +
      "\n Dugo: " + f.length() +
      "\n Ostatnia modyfikacja: " + f.lastModified());
    if(f.isFile())
      System.out.println("plik");
    else if(f.isDirectory())
      System.out.println("katalog");
  }
  public static void main(String[] args) {
    if(args.length < 1) usage();
    if(args[0].equals("-r")) {
      if(args.length != 3) usage();
      File 
        old = new File(args[1]),
        rname = new File(args[2]);
      old.renameTo(rname);
      fileData(old);
      fileData(rname);
      return; // Wyjcie z main
    }
    int count = 0;
    boolean del = false;
    if(args[0].equals("-d")) {
      count++;
      del = true;
    }
    for( ; count < args.length; count++) {
      File f = new File(args[count]);
      if(f.exists()) {
        System.out.println(f + " istnieje");
        if(del) {
          System.out.println("usuwanie..." + f);
          f.delete();
        }
      } 
      else { // Nie istnieje
        if(!del) {
          f.mkdirs();
          System.out.println("utworzono " + f);
        }
      }
      fileData(f);
    }  
  }
} ///:~
