//: c11:ClassScanner.java
// Przegld wszystkich plikw w katalogu, odnajduje
// nazwy klas i identyfikatory i sprawdza ich styl.
// Pliki powinny mie prawidow skadni.
// Nie dziaa do koca prawidowo, jest jednak
// cakiem pomocny.
import java.io.*;
import java.util.*;

class MultiStringMap extends HashMap {
  public void add(String key, String value) {
    if(!containsKey(key))
      put(key, new ArrayList());
    ((ArrayList)get(key)).add(value);
  }
  public ArrayList getArrayList(String key) {
    if(!containsKey(key)) {
      System.err.println(
        "BD: nie mona odnale klucza" + key);
      System.exit(1);
    }
    return (ArrayList)get(key);
  }
  public void printValues(PrintStream p) {
    Iterator k = keySet().iterator();
    while(k.hasNext()) {
      String oneKey = (String)k.next();
      ArrayList val = getArrayList(oneKey);
      for(int i = 0; i < val.size(); i++)
        p.println((String)val.get(i));
    }
  }
}
public class ClassScanner {
  private File path;
  private String[] fileList;
  private Properties classes = new Properties();
  private MultiStringMap 
    classMap = new MultiStringMap(),
    identMap = new MultiStringMap();
  private StreamTokenizer in;
  public ClassScanner() throws IOException {
    path = new File(".");
    fileList = path.list(new JavaFilter());
    for(int i = 0; i < fileList.length; i++) {
      System.out.println(fileList[i]);
      try {
        scanListing(fileList[i]);
      } catch(FileNotFoundException e) {
        System.err.println("Nie mona otworzy pliku " +
          fileList[i]);
      }
    }
  }
  void scanListing(String fname) 
  throws IOException {
    in = new StreamTokenizer(
        new BufferedReader(
          new FileReader(fname)));
    // To raczej nie dziaa:
    // in.slashStarComments(true);
    // in.slashSlashComments(true);
    in.ordinaryChar('/');
    in.ordinaryChar('.');
    in.wordChars('_', '_');
    in.eolIsSignificant(true);
    while(in.nextToken() != 
          StreamTokenizer.TT_EOF) {
      if(in.ttype == '/')
        eatComments();
      else if(in.ttype == 
              StreamTokenizer.TT_WORD) {
        if(in.sval.equals("class") || 
           in.sval.equals("interface")) {
          // Nazwa klasy:
             while(in.nextToken() != 
                   StreamTokenizer.TT_EOF
                   && in.ttype != 
                   StreamTokenizer.TT_WORD)
               ;
             classes.put(in.sval, in.sval);
             classMap.add(fname, in.sval);
        }
        if(in.sval.equals("import") ||
           in.sval.equals("package"))
          discardLine();
        else // Identyfikator albo sowo kluczowe
          identMap.add(fname, in.sval);
      }
    }
  }
  void discardLine() throws IOException {
    while(in.nextToken() != 
          StreamTokenizer.TT_EOF
          && in.ttype != 
          StreamTokenizer.TT_EOL)
      ; // Odrzuca atomy a do koca wiersza
  }
  // Usuwanie komentarzy przez StreamTokenizer 
  // nie dziaa. Pomijamy je w ten sposb:
  void eatComments() throws IOException {
    if(in.nextToken() != 
       StreamTokenizer.TT_EOF) {
      if(in.ttype == '/')
        discardLine();
      else if(in.ttype != '*')
        in.pushBack();
      else 
        while(true) {
          if(in.nextToken() == 
            StreamTokenizer.TT_EOF)
            break;
          if(in.ttype == '*')
            if(in.nextToken() != 
              StreamTokenizer.TT_EOF
              && in.ttype == '/')
              break;
        }
    }
  }
  public String[] classNames() {
    String[] result = new String[classes.size()];
    Iterator e = classes.keySet().iterator();
    int i = 0;
    while(e.hasNext())
      result[i++] = (String)e.next();
    return result;
  }
  public void checkClassNames() {
    Iterator files = classMap.keySet().iterator();
    while(files.hasNext()) {
      String file = (String)files.next();
      ArrayList cls = classMap.getArrayList(file);
      for(int i = 0; i < cls.size(); i++) {
        String className = (String)cls.get(i);
        if(Character.isLowerCase(
             className.charAt(0)))
          System.out.println(
            "Ze zastosowanie duych liter w nazwie klasy, plik: "
            + file + ", klasa: " 
            + className);
      }
    }
  }
  public void checkIdentNames() {
    Iterator files = identMap.keySet().iterator();
    ArrayList reportSet = new ArrayList();
    while(files.hasNext()) {
      String file = (String)files.next();
      ArrayList ids = identMap.getArrayList(file);
      for(int i = 0; i < ids.size(); i++) {
        String id = (String)ids.get(i);
        if(!classes.contains(id)) {
          // Ignoruje identyfikatory o dugoci 3 lub
          // wicej skadajce si z duych liter
          // (prawdopodobnie wartoci static final)
          if(id.length() >= 3 &&
             id.equals(
               id.toUpperCase()))
            continue;
          // Sprawdza, czy pierwsza litera jest dua:
          if(Character.isUpperCase(id.charAt(0))){
            if(reportSet.indexOf(file + id)
                == -1){ // Jeszcze nie zgoszony
              reportSet.add(file + id);
              System.out.println(
                " Ze zastosowanie duych liter w identyfikatorze, " 
                + file + ", identyfikator: " + id);
            }
          }
        }
      }
    }
  }
  static final String usage =
    "Uycie: \n" + 
    "ClassScanner classnames -a\n" +
    "\tDodaje wszystkie nazwy klas w tym\n" +
    "\tkatalogu do pliku repozytorium\n" +
    "\to nazwie 'classnames'\n" +
    "ClassScanner classnames\n" +
    "\tSprawdza wszystkie pliki javy w tym\n" +
    "\tkatalogu pod wzgldem stylu, \n" +
    "\twykorzystujc plik repozytorium 'classnames'";
  private static void usage() {
    System.err.println(usage);
    System.exit(1);
  }
  public static void main(String[] args) 
  throws IOException {
    if(args.length < 1 || args.length > 2)
      usage();
    ClassScanner c = new ClassScanner();
    File old = new File(args[0]);
    if(old.exists()) {
      try {
        // Prbuje otworzy domylny 
        // plik repozytorium:
        InputStream oldlist =
          new BufferedInputStream(
            new FileInputStream(old));
        c.classes.load(oldlist);
        oldlist.close();
      } catch(IOException e) {
        System.err.println("Nie mona otworzy "
          + old + " do odczytu");
        System.exit(1);
      }
    }
    if(args.length == 1) {
      c.checkClassNames();
      c.checkIdentNames();
    }
    // Wpisuje nazwy klas do repozytorium:
    if(args.length == 2) {
      if(!args[1].equals("-a"))
        usage();
      try {
        BufferedOutputStream out =
          new BufferedOutputStream(
            new FileOutputStream(args[0]));
        c.classes.store(out,
          "Klasy odnalezione przez ClassScanner.java");
        out.close();
      } catch(IOException e) {
        System.err.println(
          "Nie mona wypisa " + args[0]);
        System.exit(1);
      }
    }
  }
}

class JavaFilter implements FilenameFilter {
  public boolean accept(File dir, String name) {
    // Obcina informacje o ciece:
    String f = new File(name).getName();
    return f.trim().endsWith(".java");
  }
} ///:~
