//: c10:Cleanup.java
// Zwracaj uwag na wyjtki 
// w konstruktorach.
import java.io.*;

class InputFile {
  private BufferedReader in;
  InputFile(String fname) throws Exception {
    try {
      in = 
        new BufferedReader(
          new FileReader(fname));
      // Inny kod, ktry moe zgasza wyjtki
    } catch(FileNotFoundException e) {
      System.err.println(
        "Nie mona otworzy " + fname);
      // Nie by otwarty, wic go nie zamykaj
      throw e;
    } catch(Exception e) {
      // Wszystkie inne wyjtki musz zamkn plik
      try {
        in.close();
      } catch(IOException e2) {
        System.err.println(
          "wywoanie in.close() nie powiodo si");
      }
      throw e; // Zgo ponownie
    } finally {
      // Tutaj nie zamykaj pliku!!!
    }
  }
  String getLine() {
    String s;
    try {
      s = in.readLine();
    } catch(IOException e) {
      System.err.println(
        "Wywoanie readLine() nie powiodo si");
      s = "poraka";
    }
    return s;
  }
  void cleanup() {
    try {
      in.close();
    } catch(IOException e2) {
      System.err.println(
        "Wywoanie in.close() nie powiodo si");
    }
  }
}
public class Cleanup {
  public static void main(String[] args) {
    try {
      InputFile in = 
        new InputFile("Cleanup.java");
      String s;
      int i = 1;
      while((s = in.getLine()) != null)
        System.out.println(""+ i++ + ": " + s);
      in.cleanup();
    } catch(Exception e) {
      System.err.println(
        "Przechwycone w main, e.printStackTrace()");
      e.printStackTrace(System.err);
    }
  }
} ///:~
