//: c08:Month2.java
// Solidniejszy system wylicze.
package c08;

public final class Month2 {
  private String name;
  private int order;
  private Month2(int ord, String nm) { 
    order = ord; 
    name = nm; 
  }
  public String toString() { return name; }
  public final static Month2
    JAN = new Month2(1, "Stycze"), 
    FEB = new Month2(2, "Luty"),
    MAR = new Month2(3, "Marzec"),
    APR = new Month2(4, "Kwiecie"),
    MAY = new Month2(5, "Maj"),
    JUN = new Month2(6, "Czerwiec"),
    JUL = new Month2(7, "Lipiec"),
    AUG = new Month2(8, "Sierpie"),
    SEP = new Month2(9, "Wrzesie"),
    OCT = new Month2(10, "Padziernik"),
    NOV = new Month2(11, "Listopad"),
    DEC = new Month2(12, "Grudzie");
  public final static Month2[] month =  {
    JAN, FEB, MAR, APR, MAY, JUN,
    JUL, AUG, SEP, OCT, NOV, DEC
  };
  public final static Month2 number(int ord) {
    return month[ord - 1];
  }
  public static void main(String[] args) {
    Month2 m = Month2.JAN;
    System.out.println(m);
    m = Month2.number(12);
    System.out.println(m);
    System.out.println(m == Month2.DEC);
    System.out.println(m.equals(Month2.DEC));
  }
} ///:~
