//: c08:GreenhouseControls.java
// Zawarcie konkretnej aplikacji sterujcej w jednej klasie.
// Klasy wewntrzne pozwalaj na hermetyzacj 
// odmiennych funkcji kadego ze zdarze.
import c08.controller.*;

public class GreenhouseControls 
    extends Controller {
  private boolean light = false;
  private boolean water = false;
  private String thermostat = "Dzie";
  private class LightOn extends Event {
    public LightOn(long eventTime) {
      super(eventTime);
    }
    public void action() {
      // Tu naley umieci kod kontroli sprztu
      // w celu fizycznego wczenia wiata.
      light = true;
    }
    public String description() {
      return "wiato zapalone";
    }
  }
  private class LightOff extends Event {
    public LightOff(long eventTime) {
      super(eventTime);
    }
    public void action() {
      // Tu naley umieci kod kontroli sprztu
      // w celu fizycznego wyczenia wiata.
      light = false;
    }
    public String description() {
      return "wiato zgaszone";
    }
  }
  private class WaterOn extends Event {
    public WaterOn(long eventTime) {
      super(eventTime);
    }
    public void action() {
      // Tu umieci kod kontrolujcy sprzt
      water = true;
    }
    public String description() {
      return "Woda w szklarni wczona";
    }
  }
  private class WaterOff extends Event {
    public WaterOff(long eventTime) {
      super(eventTime);
    }
    public void action() {
      // Tu umieci kod kontrolujcy sprzt
      water = false;
    }
    public String description() {
      return "Woda w szklarni wyczona";
    }
  }
  private class ThermostatNight extends Event {
    public ThermostatNight(long eventTime) {
      super(eventTime);
    }
    public void action() {
      // Tu umieci kod kontrolujcy sprzt
      thermostat = "Noc";
    }
    public String description() {
      return "Termostat przeszed na ustawienia nocne";
    }
  }
  private class ThermostatDay extends Event {
    public ThermostatDay(long eventTime) {
      super(eventTime);
    }
    public void action() {
      // Tu umieci kod kontrolujcy sprzt
      thermostat = "Dzie";
    }
    public String description() {
      return "Termostat przeszed na ustawienia dzienne";
    }
  }
  // Przykad akcji wstawiajcej nowy egzemplarz swojego 
  // zdarzenia do listy zdarze:
  private int rings;
  private class Bell extends Event {
    public Bell(long eventTime) {
      super(eventTime);
    }
    public void action() {
      // Dzwoni co 2 sekundy, w sumie 'rings' razy:
      System.out.println("Dzyn!");
      if(--rings > 0)
        addEvent(new Bell(
          System.currentTimeMillis() + 2000));
    }
    public String description() {
      return "Dzwonek dzwoni";
    }
  }
  private class Restart extends Event {
    public Restart(long eventTime) {
      super(eventTime);
    }
    public void action() {
      long tm = System.currentTimeMillis();
      // Zamiast wstawia na sztywno
      // moglibymy tu odczyta konfiguracje
      // z pliku tekstowego:
      rings = 5;
      addEvent(new ThermostatNight(tm));
      addEvent(new LightOn(tm + 1000));
      addEvent(new LightOff(tm + 2000));
      addEvent(new WaterOn(tm + 3000));
      addEvent(new WaterOff(tm + 8000));
      addEvent(new Bell(tm + 9000));
      addEvent(new ThermostatDay(tm + 10000));
      // Moemy nawet doda obiekt Restart!
      addEvent(new Restart(tm + 20000));
    }
    public String description() {
      return "Restart systemu";
    }
  }
  public static void main(String[] args) {
    GreenhouseControls gc = 
      new GreenhouseControls();
    long tm = System.currentTimeMillis();
    gc.addEvent(gc.new Restart(tm));
    gc.run();
  } 
} ///:~
