//: c08:Callbacks.java
// Wykorzystanie klas wewntrznych do wywoa zwrotnych

interface Incrementable {
  void increment();
}

// Wystarczy proste zaimplementowanie interfejsu:
class Callee1 implements Incrementable {
  private int i = 0;
  public void increment() { 
    i++;
    System.out.println(i);
  }
}

class MyIncrement {
  public void increment() {
    System.out.println("Jaka inna operacja");
  }

  public static void f(MyIncrement mi) {
    mi.increment();
  }
}

// Jeeli klasa musi implementowa increment() w jaki
// inny sposb, wtedy moesz uy klasy wewntrznej:
class Callee2 extends MyIncrement {
  private int i = 0;
  private void incr() { 
    i++;
    System.out.println(i);
  }
  private class Closure implements Incrementable {
    public void increment() { incr(); }
  }
  Incrementable getCallbackReference() {
    return new Closure();
  }
}

class Caller {
  private Incrementable callbackReference;
  Caller(Incrementable cbh) {
    callbackReference = cbh;
  }
  void go() {
    callbackReference.increment();
  }
}

public class Callbacks {
  public static void main(String[] args) {
    Callee1 c1 = new Callee1();
    Callee2 c2 = new Callee2();
    MyIncrement.f(c2);
    Caller caller1 = new Caller(c1);
    Caller caller2 = 
      new Caller(c2.getCallbackReference());
    caller1.go();
    caller1.go();
    caller2.go();
    caller2.go();
  }
} ///:~
