//: c06:FinalData.java
// Skutek zastosowania final dla pl.

class Value {
  int i = 1;
}

public class FinalData {
  // To mog by stae czasu kompilacji:
  final int i1 = 9;
  static final int VAL_TWO = 99;
  // Typowa staa publiczna:
  public static final int VAL_THREE = 39;
  // To nie mog by stae czasu kompilacji:
  final int i4 = (int)(Math.random()*20);
  static final int i5 = (int)(Math.random()*20);
  
  Value v1 = new Value();
  final Value v2 = new Value();
  static final Value v3 = new Value();
  // Tablice:
  final int[] a = { 1, 2, 3, 4, 5, 6 };

  public void print(String id) {
    System.out.println(
      id + ": " + "i4 = " + i4 + 
      ", i5 = " + i5);
  }
  public static void main(String[] args) {
    FinalData fd1 = new FinalData();
    //! fd1.i1++; // Bd: nie mona zmieni wartoci
    fd1.v2.i++; // Obiekt nie jest stay!
    fd1.v1 = new Value(); // OK -- nie ostateczny
    for(int i = 0; i < fd1.a.length; i++)
      fd1.a[i]++; // Obiekt nie jest stay!
    //! fd1.v2 = new Value(); // Bd: Nie mona 
    //! fd1.v3 = new Value(); // zamieni referencji
    //! fd1.a = new int[3];

    fd1.print("fd1");
    System.out.println("Tworzenie nowego obiektu FinalData");
    FinalData fd2 = new FinalData();
    fd1.print("fd1");
    fd2.print("fd2");
  }
} ///:~
