//: c05:Lunch.java
// Demonstracja modyfikatorw dostpu do klas.
// Tworzenie klasy efektywnie prywatnej z wykorzystaniem
// prywatnych konstruktorw:

class Soup {
  private Soup() {}
  // (1) Umoliwienie tworzenia obiektu poprzez metod   
  // statyczn:
  public static Soup makeSoup() {
    return new Soup();
  }
  // (2) Stworzenie statycznego obiektu i zwracanie na
  // danie referencji do niego.
  // (Wzorzec projektowy "Singleton"):
  private static Soup ps1 = new Soup();
  public static Soup access() {
    return ps1;
  }
  public void f() {}
}

class Sandwich { // Wykorzystuje klas Lunch
  void f() { new Lunch(); }
}

// W pliku moliwa jest tylko jedna klasa publiczna:
public class Lunch {
  void test() {
    // Tego nie wolno! Konstruktor jest prywatny:
    //! Soup priv1 = new Soup();
    Soup priv2 = Soup.makeSoup();
    Sandwich f1 = new Sandwich();
    Soup.access().f();
  }
} ///:~
