//: appendixa:AddingClone.java
// Trzeba przej przez kilka zawirowa
// aby doda klonowanie do wasnej klasy.
import java.util.*;

class Int2 implements Cloneable {
  private int i;
  public Int2(int ii) { i = ii; }
  public void increment() { i++; }
  public String toString() {
    return Integer.toString(i);
  }
  public Object clone() {
    Object o = null;
    try {
      o = super.clone();
    } catch(CloneNotSupportedException e) {
      System.err.println("Int2 nie moe si sklonowa");
    }
    return o;
  }
}

// Po zaimplementowaniu Cloneable, dziedziczenie
// nie usuwa tej zdolnoci:
class Int3 extends Int2 {
  private int j; // Automatycznie duplikowana
  public Int3(int i) { super(i); }
}

public class AddingClone {
  public static void main(String[] args) {
    Int2 x = new Int2(10);
    Int2 x2 = (Int2)x.clone();
    x2.increment();
    System.out.println(
      "x = " + x + ", x2 = " + x2);
    // Wszystko dziedziczce jest take klonowalne:
    Int3 x3 = new Int3(7);
    x3 = (Int3)x3.clone();

    ArrayList v = new ArrayList();
    for(int i = 0; i < 10; i++ )
      v.add(new Int2(i));
    System.out.println("v: " + v);
    ArrayList v2 = (ArrayList)v.clone();
    // Teraz klonuj kady z elementw:
    for(int i = 0; i < v.size(); i++)
      v2.set(i, ((Int2)v2.get(i)).clone());
    // Inkrementacja wszystkich elementw v2:
    for(Iterator e = v2.iterator();
        e.hasNext(); )
      ((Int2)e.next()).increment();
    // Sprawdmy czy to zmielio elementy listy v:
    System.out.println("v: " + v);
    System.out.println("v2: " + v2);
  }
} ///:~
