//: c12:ToyTest.java
// Badanie klasy Class.

interface HasBatteries {}
interface Waterproof {}
interface ShootsThings {}
class Toy {
  // Zamie w komentarzu nastpujcy
  // konstruktor domylny, aby zobaczy bd
  // NoSuchMethodError w wierszu (*1*)
  Toy() {} 
  Toy(int i) {} 
}

class FancyToy extends Toy 
    implements HasBatteries, 
      Waterproof, ShootsThings {
  FancyToy() { super(1); }
}

public class ToyTest {
  public static void main(String[] args) 
  throws Exception {
    Class c = null;
    try {
      c = Class.forName("FancyToy");
    } catch(ClassNotFoundException e) {
      System.err.println("Nie mona odnale FancyToy");
      throw e;
    }
    printInfo(c);
    Class[] faces = c.getInterfaces();
    for(int i = 0; i < faces.length; i++)
      printInfo(faces[i]);
    Class cy = c.getSuperclass();
    Object o = null;
    try {
      // Wymaga konstruktora domylnego:
      o = cy.newInstance(); // (*1*)
    } catch(InstantiationException e) {
      System.err.println("Nie mona stworzy instancji");
      throw e;
    } catch(IllegalAccessException e) {
      System.err.println("Nie ma dostpu");
      throw e;
    }
    printInfo(o.getClass());
  }
  static void printInfo(Class cc) {
    System.out.println(
      "Nazwa klasy: " + cc.getName() +
      " jest interfejsem? [" +
      cc.isInterface() + "]");
  }
} ///:~
